/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.event.server.ServerReloadedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.blay09.mods.waystones.config.WorldGenStyle;
import net.blay09.mods.waystones.mixin.StructureTemplatePoolAccessor;
import net.blay09.mods.waystones.tag.ModBiomeTags;
import net.blay09.mods.waystones.worldgen.WaystoneFeature;
import net.blay09.mods.waystones.worldgen.WaystonePlacement;
import net.blay09.mods.waystones.worldgen.WaystoneStructurePoolElement;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ModWorldGen {
    private static final ResourceLocation waystone = new ResourceLocation("waystones", "waystone");
    private static final ResourceLocation mossyWaystone = new ResourceLocation("waystones", "mossy_waystone");
    private static final ResourceLocation sandyWaystone = new ResourceLocation("waystones", "sandy_waystone");
    private static final ResourceLocation blackstoneWaystone = new ResourceLocation("waystones", "blackstone_waystone");
    private static final ResourceLocation deepslateWaystone = new ResourceLocation("waystones", "deepslate_waystone");
    private static final ResourceLocation endStoneWaystone = new ResourceLocation("waystones", "end_stone_waystone");
    private static final ResourceLocation villageWaystoneStructure = new ResourceLocation("waystones", "village/common/waystone");
    private static final ResourceLocation desertVillageWaystoneStructure = new ResourceLocation("waystones", "village/desert/waystone");
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    public static DeferredObject<PlacementModifierType<WaystonePlacement>> waystonePlacement;

    public static void initialize(BalmWorldGen worldGen) {
        worldGen.registerFeature(waystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, ModBlocks.waystone.defaultBlockState()));
        worldGen.registerFeature(mossyWaystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, ModBlocks.mossyWaystone.defaultBlockState()));
        worldGen.registerFeature(sandyWaystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, ModBlocks.sandyWaystone.defaultBlockState()));
        worldGen.registerFeature(blackstoneWaystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, ModBlocks.blackstoneWaystone.defaultBlockState()));
        worldGen.registerFeature(deepslateWaystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, ModBlocks.deepslateWaystone.defaultBlockState()));
        worldGen.registerFeature(endStoneWaystone, () -> new WaystoneFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC, ModBlocks.endStoneWaystone.defaultBlockState()));
        waystonePlacement = worldGen.registerPlacementModifier(ModWorldGen.id("waystone"), () -> () -> WaystonePlacement.CODEC);
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag(ModBiomeTags.IS_DESERT), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.SANDY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)BiomeTags.IS_JUNGLE), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag(ModBiomeTags.IS_SWAMP), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag(ModBiomeTags.IS_MUSHROOM), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.MOSSY));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)BiomeTags.IS_NETHER), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.BLACKSTONE));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesTag((TagKey<Biome>)BiomeTags.IS_END), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.END_STONE));
        worldGen.addFeatureToBiomes(ModWorldGen.matchesNeitherTag(List.of(ModBiomeTags.IS_SWAMP, ModBiomeTags.IS_DESERT, BiomeTags.IS_JUNGLE, ModBiomeTags.IS_MUSHROOM, BiomeTags.IS_NETHER, BiomeTags.IS_END)), GenerationStep.Decoration.VEGETAL_DECORATION, ModWorldGen.getWaystoneFeature(WorldGenStyle.DEFAULT));
        Balm.getEvents().onEvent(ServerStartedEvent.class, event -> ModWorldGen.setupDynamicRegistries((RegistryAccess)event.getServer().registryAccess()));
        Balm.getEvents().onEvent(ServerReloadedEvent.class, event -> ModWorldGen.setupDynamicRegistries((RegistryAccess)event.getServer().registryAccess()));
    }

    private static BiomePredicate matchesTag(TagKey<Biome> tag) {
        return (resourceLocation, biome) -> biome.is(tag);
    }

    private static BiomePredicate matchesNeitherTag(List<TagKey<Biome>> tags) {
        return (resourceLocation, biome) -> {
            for (TagKey tag : tags) {
                if (!biome.is(tag)) continue;
                return false;
            }
            return true;
        };
    }

    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }

    private static ResourceLocation getWaystoneFeature(WorldGenStyle biomeWorldGenStyle) {
        WorldGenStyle worldGenStyle = WaystonesConfig.getActive().worldGen.wildWaystoneStyle;
        return switch (worldGenStyle) {
            case WorldGenStyle.MOSSY -> mossyWaystone;
            case WorldGenStyle.SANDY -> sandyWaystone;
            case WorldGenStyle.BLACKSTONE -> blackstoneWaystone;
            case WorldGenStyle.DEEPSLATE -> deepslateWaystone;
            case WorldGenStyle.END_STONE -> endStoneWaystone;
            case WorldGenStyle.BIOME -> {
                switch (biomeWorldGenStyle) {
                    case SANDY: {
                        yield sandyWaystone;
                    }
                    case MOSSY: {
                        yield mossyWaystone;
                    }
                    case BLACKSTONE: {
                        yield blackstoneWaystone;
                    }
                    case DEEPSLATE: {
                        yield deepslateWaystone;
                    }
                    case END_STONE: {
                        yield endStoneWaystone;
                    }
                }
                yield waystone;
            }
            default -> waystone;
        };
    }

    public static void setupDynamicRegistries(RegistryAccess registryAccess) {
        if (WaystonesConfig.getActive().worldGen.spawnInVillages != WaystonesConfigData.VillageWaystoneGeneration.DISABLED) {
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/plains/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/snowy/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/savanna/houses", villageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/desert/houses", desertVillageWaystoneStructure, 1);
            ModWorldGen.addWaystoneStructureToVillageConfig(registryAccess, "village/taiga/houses", villageWaystoneStructure, 1);
        }
    }

    private static void addWaystoneStructureToVillageConfig(RegistryAccess registryAccess, String villagePiece, ResourceLocation waystoneStructure, int weight) {
        StructureTemplatePool pool;
        Holder.Reference emptyProcessorList = registryAccess.registryOrThrow(Registries.PROCESSOR_LIST).getHolderOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        LegacySinglePoolElement piece = (LegacySinglePoolElement)StructurePoolElement.legacy((String)waystoneStructure.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        if (piece instanceof WaystoneStructurePoolElement) {
            WaystoneStructurePoolElement element = (WaystoneStructurePoolElement)piece;
            element.setIsWaystone(true);
        }
        if ((pool = (StructureTemplatePool)registryAccess.registryOrThrow(Registries.TEMPLATE_POOL).getOptional(new ResourceLocation(villagePiece)).orElse(null)) != null) {
            StructureTemplatePoolAccessor poolAccessor = (StructureTemplatePoolAccessor)pool;
            ObjectArrayList listOfPieces = new ObjectArrayList(poolAccessor.getTemplates());
            for (int i = 0; i < weight; ++i) {
                listOfPieces.add((Object)piece);
            }
            poolAccessor.setTemplates((ObjectArrayList<StructurePoolElement>)listOfPieces);
            ArrayList<Pair<StructurePoolElement, Integer>> listOfWeightedPieces = new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccessor.getRawTemplates());
            listOfWeightedPieces.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
            poolAccessor.setRawTemplates(listOfWeightedPieces);
        }
    }
}

