/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WaystoneRecipe
implements Recipe<Container> {
    private final ItemStack resultItem;
    private final Ingredient primaryIngredient;
    private final NonNullList<Ingredient> secondaryIngredients;
    private final NonNullList<Ingredient> combinedIngredients;

    public WaystoneRecipe(ItemStack resultItem, Ingredient primaryIngredient, NonNullList<Ingredient> secondaryIngredients) {
        this.resultItem = resultItem;
        this.primaryIngredient = primaryIngredient;
        this.secondaryIngredients = secondaryIngredients;
        this.combinedIngredients = NonNullList.withSize((int)5, (Object)Ingredient.EMPTY);
        this.combinedIngredients.set(0, (Object)primaryIngredient);
        for (int i = 0; i < secondaryIngredients.size(); ++i) {
            this.combinedIngredients.set(i + 1, (Object)((Ingredient)secondaryIngredients.get(i)));
        }
    }

    public boolean matches(Container inventory, Level level) {
        if (!this.primaryIngredient.test(inventory.getItem(0))) {
            return false;
        }
        StackedContents stackedContents = new StackedContents();
        int foundInputs = 0;
        for (int i = 0; i < this.combinedIngredients.size(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            ++foundInputs;
            stackedContents.accountStack(itemStack, 1);
        }
        return foundInputs == this.combinedIngredients.size() && stackedContents.canCraft((Recipe)this, null);
    }

    public ItemStack assemble(Container inventory, HolderLookup.Provider provider) {
        return this.resultItem.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.resultItem;
    }

    public ItemStack getOutputItem() {
        return this.resultItem;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.combinedIngredients;
    }

    public boolean isSpecial() {
        return true;
    }

    public String getGroup() {
        return "waystone";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.warpPlate);
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.waystoneRecipeSerializer;
    }

    public RecipeType<?> getType() {
        return ModRecipes.waystoneRecipeType;
    }

    static class Serializer
    implements RecipeSerializer<WaystoneRecipe> {
        private static final MapCodec<WaystoneRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.resultItem), (App)Ingredient.CODEC.fieldOf("primary").forGetter(recipe -> recipe.primaryIngredient), (App)Ingredient.CODEC.listOf().fieldOf("secondary").flatXmap(secondary -> {
            Object[] ingredients = (Ingredient[])secondary.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            return ingredients.length > 4 ? DataResult.error(() -> "Too many secondary ingredients for warp plate recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(recipe -> recipe.secondaryIngredients)).apply((Applicative)instance, WaystoneRecipe::new));

        Serializer() {
        }

        public MapCodec<WaystoneRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WaystoneRecipe> streamCodec() {
            return StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        }

        private static WaystoneRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            ItemStack resultItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            Ingredient primaryIngredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            int secondaryCount = buf.readVarInt();
            NonNullList secondaryIngredients = NonNullList.createWithCapacity((int)secondaryCount);
            for (int i = 0; i < secondaryCount; ++i) {
                secondaryIngredients.add((Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf)));
            }
            return new WaystoneRecipe(resultItem, primaryIngredient, (NonNullList<Ingredient>)secondaryIngredients);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, WaystoneRecipe recipe) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)recipe.resultItem);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.primaryIngredient);
            buf.writeVarInt(recipe.secondaryIngredients.size());
            for (Ingredient ingredient : recipe.secondaryIngredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
        }
    }
}

