/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SelectWaystoneMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SelectWaystoneMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("waystones", "select_waystone"));
    private final UUID waystoneUid;

    public SelectWaystoneMessage(UUID waystoneUid) {
        this.waystoneUid = waystoneUid;
    }

    public static void encode(FriendlyByteBuf buf, SelectWaystoneMessage message) {
        buf.writeUUID(message.waystoneUid);
    }

    public static SelectWaystoneMessage decode(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.readUUID();
        return new SelectWaystoneMessage(waystoneUid);
    }

    public static void handle(ServerPlayer player, SelectWaystoneMessage message) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof WaystoneSelectionMenu)) {
            return;
        }
        WaystoneSelectionMenu selectionMenu = (WaystoneSelectionMenu)abstractContainerMenu;
        WaystoneProxy waystone = new WaystoneProxy(player.server, message.waystoneUid);
        if (selectionMenu.getWaystones().stream().noneMatch(it -> it.getWaystoneUid().equals(waystone.getWaystoneUid()))) {
            Waystones.logger.warn("{} tried to teleport to waystone {} that they don't have access to.", (Object)player.getName().getString(), (Object)waystone.getWaystoneUid());
            return;
        }
        WaystonesAPI.createDefaultTeleportContext((Entity)player, waystone, it -> {
            it.setFromWaystone(selectionMenu.getWaystoneFrom());
            it.addFlags(selectionMenu.getFlags());
        }).ifLeft(WaystonesAPI::tryTeleport).ifLeft(selectionMenu.getPostTeleportHandler()).ifRight(error -> player.displayClientMessage((Component)error.getComponent().copy().withStyle(ChatFormatting.DARK_RED), false));
        player.closeContainer();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

