/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WarpPlateAttunementSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WarpPlateMenu
extends AbstractContainerMenu {
    private final WarpPlateBlockEntity blockEntity;
    private final ContainerData containerData;

    public WarpPlateMenu(int windowId, WarpPlateBlockEntity warpPlate, ContainerData containerData, Inventory playerInventory) {
        super((MenuType)ModMenus.warpPlate.get(), windowId);
        this.blockEntity = warpPlate;
        this.containerData = containerData;
        warpPlate.markReadyForAttunement();
        WarpPlateMenu.checkContainerDataCount((ContainerData)containerData, (int)1);
        this.addSlot(new WarpPlateAttunementSlot(warpPlate.getContainer(), 0, 80, 45));
        this.addSlot(new WarpPlateAttunementSlot(warpPlate.getContainer(), 1, 80, 17));
        this.addSlot(new WarpPlateAttunementSlot(warpPlate.getContainer(), 2, 108, 45));
        this.addSlot(new WarpPlateAttunementSlot(warpPlate.getContainer(), 3, 80, 73));
        this.addSlot(new WarpPlateAttunementSlot(warpPlate.getContainer(), 4, 52, 45));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 104 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 162));
        }
        this.addDataSlots(containerData);
    }

    public boolean stillValid(Player player) {
        BlockPos pos = this.blockEntity.getBlockPos();
        return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }

    public float getAttunementProgress() {
        return (float)this.containerData.get(0) / (float)this.blockEntity.getMaxAttunementTicks();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index < 5 ? !this.moveItemStackTo(slotStack, 5, this.slots.size(), true) : (!this.getSlot(0).hasItem() ? !this.moveItemStackTo(slotStack.split(1), 0, 1, false) : !this.moveItemStackTo(slotStack, 1, 5, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public Waystone getWaystone() {
        return this.blockEntity.getWaystone();
    }
}

