/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.menu;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.menu.BalmMenuFactory;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.menu.WarpPlateMenu;
import net.blay09.mods.waystones.menu.WaystoneMenu;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ModMenus {
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> waystoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> warpScrollSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> warpStoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> portstoneSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> inventorySelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> adminSelection;
    public static DeferredObject<MenuType<WaystoneSelectionMenu>> sharestoneSelection;
    public static DeferredObject<MenuType<WarpPlateMenu>> warpPlate;
    public static DeferredObject<MenuType<WaystoneMenu>> waystoneSettings;

    public static void initialize(BalmMenus menus) {
        waystoneSelection = menus.registerMenu(ModMenus.id("waystone_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, WaystoneSelectionMenu.Data>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, WaystoneSelectionMenu.Data data) {
                BlockEntity blockEntity = inventory.player.level().getBlockEntity(data.pos());
                if (blockEntity instanceof WaystoneBlockEntity) {
                    WaystoneBlockEntity waystone = (WaystoneBlockEntity)blockEntity;
                    return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)waystoneSelection.get()), waystone.getWaystone(), windowId, data.waystones(), Collections.emptySet());
                }
                return null;
            }

            public StreamCodec<RegistryFriendlyByteBuf, WaystoneSelectionMenu.Data> getStreamCodec() {
                return WaystoneSelectionMenu.STREAM_CODEC;
            }
        });
        warpScrollSelection = menus.registerMenu(ModMenus.id("warp_scroll_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, Collection<Waystone>>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, Collection<Waystone> waystones) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpScrollSelection.get()), null, windowId, waystones, Collections.emptySet());
            }

            public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getStreamCodec() {
                return WaystoneImpl.LIST_STREAM_CODEC;
            }
        });
        warpStoneSelection = menus.registerMenu(ModMenus.id("warp_stone_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, Collection<Waystone>>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, Collection<Waystone> waystones) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)warpStoneSelection.get()), null, windowId, waystones, Collections.emptySet());
            }

            public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getStreamCodec() {
                return WaystoneImpl.LIST_STREAM_CODEC;
            }
        });
        portstoneSelection = menus.registerMenu(ModMenus.id("portstone_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, Collection<Waystone>>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, Collection<Waystone> waystones) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)portstoneSelection.get()), null, windowId, waystones, Collections.emptySet());
            }

            public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getStreamCodec() {
                return WaystoneImpl.LIST_STREAM_CODEC;
            }
        });
        sharestoneSelection = menus.registerMenu(ModMenus.id("sharestone_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, WaystoneSelectionMenu.Data>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, WaystoneSelectionMenu.Data data) {
                BlockEntity blockEntity = inventory.player.level().getBlockEntity(data.pos());
                if (blockEntity instanceof WaystoneBlockEntity) {
                    WaystoneBlockEntity waystone = (WaystoneBlockEntity)blockEntity;
                    return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)sharestoneSelection.get()), waystone.getWaystone(), windowId, data.waystones(), Collections.emptySet());
                }
                return null;
            }

            public StreamCodec<RegistryFriendlyByteBuf, WaystoneSelectionMenu.Data> getStreamCodec() {
                return WaystoneSelectionMenu.STREAM_CODEC;
            }
        });
        inventorySelection = menus.registerMenu(ModMenus.id("inventory_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, Collection<Waystone>>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, Collection<Waystone> waystones) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)inventorySelection.get()), null, windowId, waystones, Set.of(TeleportFlags.INVENTORY_BUTTON));
            }

            public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getStreamCodec() {
                return WaystoneImpl.LIST_STREAM_CODEC;
            }
        });
        adminSelection = menus.registerMenu(ModMenus.id("admin_selection"), (BalmMenuFactory)new BalmMenuFactory<WaystoneSelectionMenu, Collection<Waystone>>(){

            public WaystoneSelectionMenu create(int windowId, Inventory inventory, Collection<Waystone> waystones) {
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)adminSelection.get()), null, windowId, waystones, Set.of(TeleportFlags.ADMIN));
            }

            public StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> getStreamCodec() {
                return WaystoneImpl.LIST_STREAM_CODEC;
            }
        });
        warpPlate = menus.registerMenu(ModMenus.id("warp_plate"), (BalmMenuFactory)new BalmMenuFactory<WarpPlateMenu, BlockPos>(){

            public WarpPlateMenu create(int windowId, Inventory inventory, BlockPos pos) {
                BlockEntity blockEntity = inventory.player.level().getBlockEntity(pos);
                if (blockEntity instanceof WarpPlateBlockEntity) {
                    WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)blockEntity;
                    return new WarpPlateMenu(windowId, warpPlate, warpPlate.getContainerData(), inventory);
                }
                return null;
            }

            public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getStreamCodec() {
                return BlockPos.STREAM_CODEC.cast();
            }
        });
        waystoneSettings = menus.registerMenu(ModMenus.id("waystone"), (BalmMenuFactory)new BalmMenuFactory<WaystoneMenu, WaystoneMenu.Data>(){

            public WaystoneMenu create(int windowId, Inventory inventory, WaystoneMenu.Data data) {
                BlockEntity blockEntity = inventory.player.level().getBlockEntity(data.pos());
                if (blockEntity instanceof WaystoneBlockEntityBase) {
                    WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
                    return new WaystoneMenu(windowId, data.waystone(), waystoneBlockEntity, waystoneBlockEntity.getContainerData(), inventory, data.canEdit());
                }
                return null;
            }

            public StreamCodec<RegistryFriendlyByteBuf, WaystoneMenu.Data> getStreamCodec() {
                return WaystoneMenu.STREAM_CODEC;
            }
        });
    }

    @NotNull
    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }
}

