/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.tag.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WaystoneImpl
implements Waystone,
MutableWaystone {
    public static final StreamCodec<RegistryFriendlyByteBuf, Waystone> STREAM_CODEC = StreamCodec.of(WaystoneImpl::write, WaystoneImpl::read);
    public static final StreamCodec<RegistryFriendlyByteBuf, Collection<Waystone>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new));
    private final ResourceLocation waystoneType;
    private final UUID waystoneUid;
    private final WaystoneOrigin origin;
    private ResourceKey<Level> dimension;
    private BlockPos pos;
    private Component name = Component.empty();
    private WaystoneVisibility visibility;
    private UUID ownerUid;

    public WaystoneImpl(ResourceLocation waystoneType, UUID waystoneUid, ResourceKey<Level> dimension, BlockPos pos, WaystoneOrigin origin, @Nullable UUID ownerUid) {
        this.waystoneType = waystoneType;
        this.waystoneUid = waystoneUid;
        this.dimension = dimension;
        this.pos = pos;
        this.origin = origin;
        this.ownerUid = ownerUid;
        this.visibility = WaystoneVisibility.fromWaystoneType(waystoneType);
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public void setName(Component name) {
        this.name = name;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public WaystoneOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public WaystoneVisibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(WaystoneVisibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean isOwner(Player player) {
        return this.ownerUid == null || player.getGameProfile().getId().equals(this.ownerUid) || player.getAbilities().instabuild;
    }

    @Override
    public void setOwnerUid(@Nullable UUID ownerUid) {
        this.ownerUid = ownerUid;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public UUID getOwnerUid() {
        return this.ownerUid;
    }

    @Override
    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    @Override
    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public ResourceLocation getWaystoneType() {
        return this.waystoneType;
    }

    @Override
    public boolean isValidInLevel(ServerLevel level) {
        BlockState state = level.getBlockState(this.pos);
        return state.is(ModBlockTags.IS_TELEPORT_TARGET);
    }

    public static List<Waystone> readList(RegistryFriendlyByteBuf buf) {
        int size = buf.readShort();
        ArrayList<Waystone> waystones = new ArrayList<Waystone>(size);
        for (int i = 0; i < size; ++i) {
            waystones.add(WaystoneImpl.read(buf));
        }
        return waystones;
    }

    public static Waystone read(RegistryFriendlyByteBuf buf) {
        UUID waystoneUid = buf.readUUID();
        ResourceLocation waystoneType = buf.readResourceLocation();
        Component name = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
        WaystoneVisibility visibility = (WaystoneVisibility)buf.readEnum(WaystoneVisibility.class);
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(buf.readUtf(250)));
        BlockPos pos = buf.readBlockPos();
        WaystoneOrigin origin = (WaystoneOrigin)buf.readEnum(WaystoneOrigin.class);
        WaystoneImpl waystone = new WaystoneImpl(waystoneType, waystoneUid, (ResourceKey<Level>)dimension, pos, origin, null);
        waystone.setName(name);
        waystone.setVisibility(visibility);
        return waystone;
    }

    private static BlockPos readLegacyBlockPos(CompoundTag compound) {
        return new BlockPos(compound.getInt("x"), compound.getInt("y"), compound.getInt("z"));
    }

    public static Waystone read(CompoundTag compound, HolderLookup.Provider provider) {
        WaystoneOrigin origin;
        UUID waystoneUid = NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("WaystoneUid")));
        String legacyName = compound.getString("Name");
        MutableComponent name = compound.contains("NameV2") ? Component.Serializer.fromJson((String)compound.getString("NameV2"), (HolderLookup.Provider)provider) : Component.literal((String)legacyName);
        ResourceKey dimensionType = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(compound.getString("World")));
        BlockPos pos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"BlockPos").orElseGet(() -> WaystoneImpl.readLegacyBlockPos(compound.getCompound("BlockPos")));
        boolean legacyWasGenerated = compound.getBoolean("WasGenerated");
        WaystoneOrigin waystoneOrigin = origin = legacyWasGenerated ? WaystoneOrigin.WILDERNESS : WaystoneOrigin.UNKNOWN;
        if (compound.contains("Origin")) {
            try {
                origin = WaystoneOrigin.valueOf(compound.getString("Origin"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        UUID ownerUid = compound.contains("OwnerUid") ? NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("OwnerUid"))) : null;
        ResourceLocation waystoneType = compound.contains("Type") ? new ResourceLocation(compound.getString("Type")) : WaystoneTypes.WAYSTONE;
        WaystoneImpl waystone = new WaystoneImpl(waystoneType, waystoneUid, (ResourceKey<Level>)dimensionType, pos, origin, ownerUid);
        waystone.setName((Component)name);
        if (compound.contains("Visibility")) {
            waystone.setVisibility(WaystoneVisibility.valueOf(compound.getString("Visibility")));
        } else {
            waystone.setVisibility(compound.getBoolean("IsGlobal") ? WaystoneVisibility.GLOBAL : WaystoneVisibility.ACTIVATION);
        }
        return waystone;
    }

    public static void writeList(RegistryFriendlyByteBuf buf, Collection<Waystone> waystones) {
        buf.writeShort(waystones.size());
        for (Waystone waystone : waystones) {
            WaystoneImpl.write(buf, waystone);
        }
    }

    public static void write(RegistryFriendlyByteBuf buf, Waystone waystone) {
        buf.writeUUID(waystone.getWaystoneUid());
        buf.writeResourceLocation(waystone.getWaystoneType());
        ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)waystone.getName());
        buf.writeEnum((Enum)waystone.getVisibility());
        buf.writeResourceLocation(waystone.getDimension().location());
        buf.writeBlockPos(waystone.getPos());
        buf.writeEnum((Enum)waystone.getOrigin());
    }

    public static CompoundTag write(Waystone waystone, CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("WaystoneUid", (Tag)NbtUtils.createUUID((UUID)waystone.getWaystoneUid()));
        compound.putString("Type", waystone.getWaystoneType().toString());
        compound.putString("NameV2", Component.Serializer.toJson((Component)waystone.getName(), (HolderLookup.Provider)provider));
        compound.putString("World", waystone.getDimension().location().toString());
        compound.put("BlockPos", NbtUtils.writeBlockPos((BlockPos)waystone.getPos()));
        compound.putString("Origin", waystone.getOrigin().name());
        if (waystone.getOwnerUid() != null) {
            compound.put("OwnerUid", (Tag)NbtUtils.createUUID((UUID)waystone.getOwnerUid()));
        }
        compound.putString("Visibility", waystone.getVisibility().name());
        return compound;
    }
}

