/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.recipe.WaystoneRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class WaystoneJeiRecipeCategory
implements IRecipeCategory<WaystoneRecipe> {
    public static final RecipeType<WaystoneRecipe> TYPE = RecipeType.create((String)"waystones", (String)"waystone", WaystoneRecipe.class);
    public static final ResourceLocation UID = new ResourceLocation("waystones", "waystone");
    private static final ResourceLocation texture = new ResourceLocation("waystones", "textures/gui/jei/warp_plate.png");
    private final IDrawable background;
    private final IDrawable icon;

    public WaystoneJeiRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 128, 74);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.warpPlate));
    }

    public RecipeType<WaystoneRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)UID.toString());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WaystoneRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> inputs = recipe.getIngredients();
        builder.addSlot(RecipeIngredientRole.INPUT, 29, 29).addIngredients((Ingredient)inputs.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 29, 1).addIngredients((Ingredient)inputs.get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 57, 29).addIngredients((Ingredient)inputs.get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 29, 57).addIngredients((Ingredient)inputs.get(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 29).addIngredients((Ingredient)inputs.get(4));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 111, 29).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getOutputItem());
    }
}

