/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.display.WaypointGroup;
import journeymap.client.api.event.ClientEvent;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystoneRemoveReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@ClientPlugin
public class JourneyMapIntegration
implements IClientPlugin {
    private static final UUID WAYSTONE_GROUP_ID = UUID.fromString("005bdf11-2dbb-4a27-8aa4-0184e86fa33c");
    private static final UUID SHARESTONE_GROUP_ID = UUID.fromString("199e2989-df63-4ab4-bd5d-2fa24e72b4fc");
    private IClientAPI api;
    private boolean journeyMapReady;
    private final List<Runnable> scheduledJobsWhenReady = new ArrayList<Runnable>();
    private static JourneyMapIntegration instance;

    public JourneyMapIntegration() {
        instance = this;
        Balm.getEvents().onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceived);
        Balm.getEvents().onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        Balm.getEvents().onEvent(WaystoneRemoveReceivedEvent.class, this::onWaystoneRemoveReceived);
    }

    public void initialize(IClientAPI iClientAPI) {
        this.api = iClientAPI;
        this.api.subscribe("waystones", EnumSet.of(ClientEvent.Type.MAPPING_STARTED));
    }

    @Nullable
    public static JourneyMapIntegration getInstance() {
        return instance;
    }

    public String getModId() {
        return "waystones";
    }

    public void onEvent(ClientEvent clientEvent) {
        if (clientEvent.type == ClientEvent.Type.MAPPING_STARTED) {
            this.journeyMapReady = true;
            for (Runnable scheduledJob : this.scheduledJobsWhenReady) {
                scheduledJob.run();
            }
            this.scheduledJobsWhenReady.clear();
        }
    }

    public void onWaystonesListReceived(WaystonesListReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.updateAllWaypoints(event.getWaystoneType(), event.getWaystones()));
        }
    }

    private boolean isSupportedWaystoneType(ResourceLocation waystoneType) {
        return waystoneType.equals((Object)WaystoneTypes.WAYSTONE) || WaystoneTypes.isSharestone(waystoneType);
    }

    private static boolean shouldManageWaypoints() {
        WaystonesConfigData config = WaystonesConfig.getActive();
        if (config.compatibility.preferJourneyMapIntegrationMod && Balm.isModLoaded((String)"jmi")) {
            return false;
        }
        return config.compatibility.journeyMap;
    }

    public void onWaystoneUpdateReceived(WaystoneUpdateReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystone().getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.updateWaypoint(event.getWaystone()));
        }
    }

    public void onWaystoneRemoveReceived(WaystoneRemoveReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.removeWaypoint(event.getWaystoneType(), event.getWaystoneId()));
        }
    }

    private void runWhenJourneyMapIsReady(Runnable runnable) {
        if (this.journeyMapReady) {
            runnable.run();
        } else {
            this.scheduledJobsWhenReady.add(runnable);
        }
    }

    private void updateAllWaypoints(ResourceLocation waystoneType, List<Waystone> waystones) {
        String idPrefix = waystoneType.getPath() + ":";
        HashSet<String> stillExistingIds = new HashSet<String>();
        for (Waystone waystone : waystones) {
            stillExistingIds.add(this.getPrefixedWaystoneId(waystone));
            this.updateWaypoint(waystone);
        }
        List waypoints = this.api.getWaypoints("waystones");
        for (Waypoint waypoint : waypoints) {
            if (!waypoint.getId().startsWith(idPrefix) || stillExistingIds.contains(waypoint.getId())) continue;
            this.api.remove((Displayable)waypoint);
        }
    }

    private void removeWaypoint(ResourceLocation waystoneType, UUID waystoneId) {
        String prefixedId = this.getPrefixedWaystoneId(waystoneType, waystoneId);
        Waypoint waypoint = this.api.getWaypoint("waystones", prefixedId);
        if (waypoint != null) {
            this.api.remove((Displayable)waypoint);
        }
    }

    private void updateWaypoint(Waystone waystone) {
        try {
            String prefixedId = this.getPrefixedWaystoneId(waystone);
            Waypoint oldWaypoint = this.api.getWaypoint("waystones", prefixedId);
            Component waystoneName = waystone.hasName() ? waystone.getName() : Component.translatable((String)"waystones.map.untitled_waystone");
            Waypoint waypoint = new Waypoint("waystones", prefixedId, waystoneName.getString(), waystone.getDimension(), waystone.getPos());
            waypoint.setName(waystoneName.getString());
            waypoint.setGroup(JourneyMapIntegration.getWaystoneGroup(waystone));
            if (oldWaypoint != null) {
                waypoint.setEnabled(oldWaypoint.isEnabled());
                if (oldWaypoint.hasColor()) {
                    waypoint.setColor(oldWaypoint.getColor().intValue());
                }
                if (oldWaypoint.hasBackgroundColor()) {
                    waypoint.setBackgroundColor(oldWaypoint.getBackgroundColor().intValue());
                }
                this.api.remove((Displayable)oldWaypoint);
            }
            this.api.show((Displayable)waypoint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static WaypointGroup getWaystoneGroup(Waystone waystone) {
        if (WaystoneTypes.isSharestone(waystone.getWaystoneType())) {
            return new WaypointGroup("waystones", SHARESTONE_GROUP_ID.toString(), "Sharestones");
        }
        return new WaypointGroup("waystones", WAYSTONE_GROUP_ID.toString(), "Waystones");
    }

    private String getPrefixedWaystoneId(Waystone waystone) {
        return this.getPrefixedWaystoneId(waystone.getWaystoneType(), waystone.getWaystoneUid());
    }

    private String getPrefixedWaystoneId(ResourceLocation waystoneType, UUID waystoneId) {
        return waystoneType.getPath() + ":" + waystoneId.toString();
    }
}

