/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.blay09.mods.waystones.client.gui.widget.WaystoneVisbilityButton;
import net.blay09.mods.waystones.core.WaystoneVisibilities;
import net.blay09.mods.waystones.menu.WaystoneMenu;
import net.blay09.mods.waystones.network.message.EditWaystoneMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WaystoneScreen
extends AbstractContainerScreen<WaystoneMenu> {
    private static final ResourceLocation WAYSTONE_GUI_TEXTURES = new ResourceLocation("waystones", "textures/gui/menu/waystone.png");
    private final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();
    private EditBox textField;
    private WaystoneVisbilityButton visibilityButton;

    public WaystoneScreen(WaystoneMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.imageHeight = 210;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void init() {
        super.init();
        Waystone waystone = ((WaystoneMenu)this.menu).getWaystone();
        String oldText = waystone.getName().getString();
        if (this.textField != null) {
            oldText = this.textField.getValue();
        }
        WaystoneVisibility oldVisibility = waystone.getVisibility();
        if (this.visibilityButton != null) {
            oldVisibility = this.visibilityButton.getVisibility();
        }
        this.tooltipProviders.clear();
        this.textField = new EditBox(Minecraft.getInstance().font, this.leftPos + 33, this.topPos + 9, 110, 16, this.textField, (Component)Component.empty());
        this.textField.setMaxLength(128);
        this.textField.setValue(oldText);
        this.textField.setEditable(((WaystoneMenu)this.menu).canEdit());
        this.addRenderableWidget(this.textField);
        if (((WaystoneMenu)this.menu).canEdit() && oldText.isEmpty()) {
            this.setInitialFocus((GuiEventListener)this.textField);
        }
        List<WaystoneVisibility> visibilityOptions = WaystoneVisibilities.getVisibilityOptions((Player)Minecraft.getInstance().player, waystone);
        this.visibilityButton = new WaystoneVisbilityButton(this.leftPos + 9, this.topPos + 8, oldVisibility, visibilityOptions, ((WaystoneMenu)this.menu).canEdit());
        this.addRenderableWidget(this.visibilityButton);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (((WaystoneMenu)this.menu).canEdit() && this.textField.isMouseOver(mouseX, mouseY) && button == 1) {
            this.textField.setValue("");
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textField.keyPressed(keyCode, scanCode, modifiers) || this.textField.isFocused()) {
            if (keyCode == 256 || keyCode == 257) {
                this.onClose();
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        for (ITooltipProvider tooltipProvider : this.tooltipProviders) {
            if (!tooltipProvider.shouldShowTooltip()) continue;
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltipProvider.getTooltipComponents(), Optional.empty(), mouseX, mouseY);
        }
        if (this.textField != null && this.textField.getValue().isEmpty()) {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"waystones.untitled_waystone"), this.textField.getX() + 4, this.textField.getY() + 4, 0x808080);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(WAYSTONE_GUI_TEXTURES, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(WAYSTONE_GUI_TEXTURES, this.leftPos + 86, this.topPos + 53, 176, 4, 4, (int)(10.0f * ((WaystoneMenu)this.menu).getAttunementProgress()));
        guiGraphics.blit(WAYSTONE_GUI_TEXTURES, this.leftPos + 107 - (int)(10.0f * ((WaystoneMenu)this.menu).getAttunementProgress()), this.topPos + 70, 176, 0, (int)(10.0f * ((WaystoneMenu)this.menu).getAttunementProgress()), 4);
        guiGraphics.blit(WAYSTONE_GUI_TEXTURES, this.leftPos + 86, this.topPos + 91 - (int)(10.0f * ((WaystoneMenu)this.menu).getAttunementProgress()), 176, 4, 4, (int)(10.0f * ((WaystoneMenu)this.menu).getAttunementProgress()));
        guiGraphics.blit(WAYSTONE_GUI_TEXTURES, this.leftPos + 69, this.topPos + 70, 176, 0, (int)(10.0f * ((WaystoneMenu)this.menu).getAttunementProgress()), 4);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public void onClose() {
        if (this.textField != null && this.visibilityButton != null) {
            Balm.getNetworking().sendToServer((CustomPacketPayload)new EditWaystoneMessage(((WaystoneMenu)this.menu).getWaystone().getWaystoneUid(), this.textField.getValue(), this.visibilityButton.getVisibility()));
        }
        super.onClose();
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        if (widget instanceof ITooltipProvider) {
            this.tooltipProviders.add((ITooltipProvider)widget);
        }
        return (T)super.addRenderableWidget(widget);
    }
}

