/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.block.entity.OnLoadHandler;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.ExtractionAwareContainer;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.recipe.ModRecipes;
import net.blay09.mods.waystones.recipe.WaystoneRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockEntityBase
extends BalmBlockEntity
implements OnLoadHandler,
CustomRenderBoundingBox,
BalmContainerProvider {
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int i) {
            return WaystoneBlockEntityBase.this.attunementTicks;
        }

        public void set(int i, int j) {
            WaystoneBlockEntityBase.this.attunementTicks = j;
        }

        public int getCount() {
            return 1;
        }
    };
    protected final DefaultContainer container = new WaystoneContainer(5);
    private boolean readyForAttunement;
    protected boolean completedFirstAttunement;
    protected int attunementTicks;
    private Waystone waystone = InvalidWaystone.INSTANCE;
    private UUID waystoneUid;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    public WaystoneBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("Items", (Tag)this.container.serialize(provider));
        if (this.waystone.isValid()) {
            tag.put("UUID", (Tag)NbtUtils.createUUID((UUID)this.waystone.getWaystoneUid()));
        } else if (this.waystoneUid != null) {
            tag.put("UUID", (Tag)NbtUtils.createUUID((UUID)this.waystoneUid));
        }
        tag.putBoolean("ReadyForAttunement", this.readyForAttunement);
        tag.putBoolean("CompletedFirstAttunement", this.completedFirstAttunement);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.container.deserialize(compound.getCompound("Items"), provider);
        if (compound.contains("UUID", 11)) {
            this.waystoneUid = NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("UUID")));
        }
        if (compound.contains("Waystone", 10)) {
            Waystone syncedWaystone = WaystoneImpl.read(compound.getCompound("Waystone"), provider);
            WaystoneManagerImpl.get(null).updateWaystone(syncedWaystone);
            this.waystone = new WaystoneProxy(null, syncedWaystone.getWaystoneUid());
        }
        this.readyForAttunement = compound.getBoolean("ReadyForAttunement");
        this.completedFirstAttunement = compound.getBoolean("CompletedFirstAttunement");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        UUID waystoneUidComponent = (UUID)input.get((DataComponentType)ModComponents.waystone.get());
        if (waystoneUidComponent != null) {
            this.waystoneUid = waystoneUidComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set((DataComponentType)ModComponents.waystone.get(), (Object)(this.waystone.isValid() ? this.waystone.getWaystoneUid() : this.waystoneUid));
    }

    public void writeUpdateTag(CompoundTag tag) {
        tag.put("Waystone", (Tag)WaystoneImpl.write(this.getWaystone(), new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess()));
    }

    public void onLoad() {
        Waystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof WaystoneImpl && this.level != null) {
            ((WaystoneImpl)backingWaystone).setDimension((ResourceKey<Level>)this.level.dimension());
            ((WaystoneImpl)backingWaystone).setPos(this.worldPosition);
        }
        this.sync();
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 2), (double)(this.worldPosition.getZ() + 1));
    }

    public Waystone getWaystone() {
        if (!(this.waystone.isValid() || this.level == null || this.level.isClientSide || this.shouldNotInitialize)) {
            BlockState state;
            if (this.waystoneUid != null) {
                this.waystone = new WaystoneProxy(this.level.getServer(), this.waystoneUid);
            }
            if (!this.waystone.isValid() && (state = this.getBlockState()).getBlock() instanceof WaystoneBlockBase) {
                BlockEntity blockEntity;
                WaystoneOrigin origin;
                DoubleBlockHalf half = state.hasProperty(WaystoneBlockBase.HALF) ? (DoubleBlockHalf)state.getValue(WaystoneBlockBase.HALF) : DoubleBlockHalf.LOWER;
                WaystoneOrigin waystoneOrigin = origin = state.hasProperty(WaystoneBlockBase.ORIGIN) ? (WaystoneOrigin)((Object)state.getValue(WaystoneBlockBase.ORIGIN)) : WaystoneOrigin.UNKNOWN;
                if (half == DoubleBlockHalf.LOWER) {
                    this.initializeWaystone((ServerLevelAccessor)Objects.requireNonNull(this.level), null, origin);
                } else if (half == DoubleBlockHalf.UPPER && (blockEntity = this.level.getBlockEntity(this.worldPosition.below())) instanceof WaystoneBlockEntityBase) {
                    this.initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (this.waystone.isValid()) {
                this.waystoneUid = this.waystone.getWaystoneUid();
                this.sync();
            }
        }
        return this.waystone;
    }

    protected abstract ResourceLocation getWaystoneType();

    public void initializeWaystone(ServerLevelAccessor world, @Nullable LivingEntity player, WaystoneOrigin origin) {
        WaystoneImpl waystone = new WaystoneImpl(this.getWaystoneType(), UUID.randomUUID(), (ResourceKey<Level>)world.getLevel().dimension(), this.worldPosition, origin, player != null ? player.getUUID() : null);
        WaystoneManagerImpl.get(world.getServer()).addWaystone(waystone);
        this.waystone = waystone;
        this.setChanged();
        this.sync();
        if (!this.isCompletedFirstAttunement()) {
            this.initializeInventory(world);
        }
    }

    public void initializeFromExisting(ServerLevelAccessor world, WaystoneImpl existingWaystone, ItemStack itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((ResourceKey<Level>)world.getLevel().dimension());
        existingWaystone.setPos(this.worldPosition);
        this.setChanged();
        this.sync();
        this.completedFirstAttunement = itemStack.has((DataComponentType)ModComponents.warpPlateCompletedFirstAttunement.get());
        if (!this.isCompletedFirstAttunement()) {
            this.initializeInventory(world);
        }
    }

    public void initializeFromBase(WaystoneBlockEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
        this.setChanged();
        this.sync();
    }

    public void uninitializeWaystone() {
        if (this.waystone.isValid()) {
            WaystoneManagerImpl.get(this.level.getServer()).removeWaystone(this.waystone);
            PlayerWaystoneManager.removeKnownWaystone(this.level.getServer(), this.waystone);
            WaystoneSyncManager.sendWaystoneRemovalToAll(this.level.getServer(), this.waystone, true);
        }
        this.waystone = InvalidWaystone.INSTANCE;
        this.shouldNotInitialize = true;
        DoubleBlockHalf half = (DoubleBlockHalf)this.getBlockState().getValue((Property)WaystoneBlock.HALF);
        BlockPos otherPos = half == DoubleBlockHalf.UPPER ? this.worldPosition.below() : this.worldPosition.above();
        BlockEntity blockEntity = Objects.requireNonNull(this.level).getBlockEntity(otherPos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneTile = (WaystoneBlockEntityBase)blockEntity;
            waystoneTile.waystone = InvalidWaystone.INSTANCE;
            waystoneTile.shouldNotInitialize = true;
        }
        this.setChanged();
        this.sync();
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public abstract MenuProvider getMenuProvider();

    @Nullable
    public abstract MenuProvider getSettingsMenuProvider();

    public int getMaxAttunementTicks() {
        return 30;
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }

    @Nullable
    protected WaystoneRecipe trySelectRecipe() {
        if (!this.readyForAttunement) {
            return null;
        }
        if (this.level == null) {
            return null;
        }
        if (this.container.getItem(0).getCount() > 1) {
            return null;
        }
        return this.level.getRecipeManager().getRecipeFor(ModRecipes.waystoneRecipeType, (Container)this.container, this.level).map(RecipeHolder::value).orElse(null);
    }

    public void serverTick() {
        WaystoneRecipe recipe = this.trySelectRecipe();
        if (recipe != null) {
            ++this.attunementTicks;
            if (this.attunementTicks >= this.getMaxAttunementTicks()) {
                this.attunementTicks = 0;
                this.craft(recipe);
            }
        } else {
            this.attunementTicks = 0;
        }
    }

    protected void craft(WaystoneRecipe recipe) {
        ItemStack attunedShard = recipe.assemble((Container)this.container, (HolderLookup.Provider)RegistryAccess.EMPTY);
        WaystonesAPI.setBoundWaystone(attunedShard, this.getWaystone());
        ItemStack centerStack = this.container.getItem(0);
        if (centerStack.getCount() > 1) {
            centerStack = centerStack.copyWithCount(centerStack.getCount() - 1);
            if (!Minecraft.getInstance().player.getInventory().add(centerStack)) {
                Minecraft.getInstance().player.drop(centerStack, false);
            }
        }
        this.container.setItem(0, attunedShard);
        for (int i = 1; i <= 4; ++i) {
            this.container.getItem(i).shrink(1);
        }
        this.completedFirstAttunement = true;
    }

    public Collection<? extends Waystone> getAuxiliaryTargets() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack item = this.container.getItem(i);
            WaystonesAPI.getBoundWaystone(null, item).ifPresent(result::add);
        }
        return result;
    }

    public boolean shouldPerformInitialAttunement() {
        return false;
    }

    public boolean isCompletedFirstAttunement() {
        return !this.shouldPerformInitialAttunement() || this.completedFirstAttunement;
    }

    public void markReadyForAttunement() {
        this.readyForAttunement = true;
    }

    private void initializeInventory(ServerLevelAccessor levelAccessor) {
        WaystoneRecipe initializingRecipe = levelAccessor.getLevel().getRecipeManager().getAllRecipesFor(ModRecipes.waystoneRecipeType).stream().filter(holder -> holder.id().getNamespace().equals("waystones") && holder.id().getPath().equals("attuned_shard")).map(RecipeHolder::value).findFirst().orElse(null);
        if (initializingRecipe == null) {
            Waystones.logger.error("Failed to find Attunement recipe for initial attunement");
            this.completedFirstAttunement = true;
            return;
        }
        for (int i = 0; i < 5; ++i) {
            Ingredient ingredient = (Ingredient)initializingRecipe.getIngredients().get(i);
            ItemStack[] ingredientItems = ingredient.getItems();
            ItemStack ingredientItem = ingredientItems.length > 0 ? ingredientItems[0] : ItemStack.EMPTY;
            this.container.setItem(i, ingredientItem.copy());
        }
    }

    public Container getContainer() {
        return this.container;
    }

    private class WaystoneContainer
    extends DefaultContainer
    implements ExtractionAwareContainer {
        public WaystoneContainer(int size) {
            super(size);
        }

        public boolean canTakeItem(Container container, int slot, ItemStack itemStack) {
            return WaystoneBlockEntityBase.this.isCompletedFirstAttunement();
        }

        public boolean canExtractItem(int i) {
            return WaystoneBlockEntityBase.this.isCompletedFirstAttunement();
        }
    }
}

