/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.api;

import net.blay09.mods.waystones.api.WaystoneTypes;
import net.minecraft.resources.ResourceLocation;

public enum WaystoneVisibility {
    ACTIVATION,
    GLOBAL,
    SHARD_ONLY,
    ORANGE_SHARESTONE,
    MAGENTA_SHARESTONE,
    LIGHT_BLUE_SHARESTONE,
    YELLOW_SHARESTONE,
    LIME_SHARESTONE,
    PINK_SHARESTONE,
    GRAY_SHARESTONE,
    LIGHT_GRAY_SHARESTONE,
    CYAN_SHARESTONE,
    PURPLE_SHARESTONE,
    BLUE_SHARESTONE,
    BROWN_SHARESTONE,
    GREEN_SHARESTONE,
    RED_SHARESTONE,
    BLACK_SHARESTONE;


    public static WaystoneVisibility fromWaystoneType(ResourceLocation waystoneType) {
        if (WaystoneTypes.isSharestone(waystoneType)) {
            return switch (waystoneType.getPath()) {
                case "orange_sharestone" -> ORANGE_SHARESTONE;
                case "magenta_sharestone" -> MAGENTA_SHARESTONE;
                case "light_blue_sharestone" -> LIGHT_BLUE_SHARESTONE;
                case "yellow_sharestone" -> YELLOW_SHARESTONE;
                case "lime_sharestone" -> LIME_SHARESTONE;
                case "pink_sharestone" -> PINK_SHARESTONE;
                case "gray_sharestone" -> GRAY_SHARESTONE;
                case "light_gray_sharestone" -> LIGHT_GRAY_SHARESTONE;
                case "cyan_sharestone" -> CYAN_SHARESTONE;
                case "purple_sharestone" -> PURPLE_SHARESTONE;
                case "blue_sharestone" -> BLUE_SHARESTONE;
                case "brown_sharestone" -> BROWN_SHARESTONE;
                case "green_sharestone" -> GREEN_SHARESTONE;
                case "red_sharestone" -> RED_SHARESTONE;
                case "black_sharestone" -> BLACK_SHARESTONE;
                default -> ACTIVATION;
            };
        }
        if (waystoneType.equals((Object)WaystoneTypes.WARP_PLATE)) {
            return SHARD_ONLY;
        }
        if (waystoneType.equals((Object)WaystoneTypes.LANDING_STONE)) {
            return SHARD_ONLY;
        }
        return ACTIVATION;
    }

    public int getIconX() {
        return 176;
    }

    public int getIconY() {
        return switch (this.ordinal()) {
            case 0 -> 32;
            case 1 -> 50;
            case 2 -> 68;
            default -> 86;
        };
    }
}

