/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.permission.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionType;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import org.apache.commons.lang3.tuple.Pair;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.player.permission.api.IPermissionNodeAPI;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemAPI;
import xaero.pac.common.server.player.permission.api.UsedPermissionNodes;

public class ForgePermissionsSystem
implements IPlayerPermissionSystemAPI {
    private static final Map<IPermissionNodeAPI<?>, PermissionNode<?>> REGISTERED_NODES = new HashMap();

    @Override
    @Nonnull
    public OptionalInt getIntPermission(@Nonnull ServerPlayer player, @Nonnull IPermissionNodeAPI<Integer> node) {
        PermissionNode<?> forgeNode = REGISTERED_NODES.get(node);
        if (forgeNode == null) {
            return OptionalInt.empty();
        }
        Object value = PermissionAPI.getPermission((ServerPlayer)player, forgeNode, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        if (!(value instanceof Integer)) {
            return OptionalInt.empty();
        }
        Integer integer = (Integer)value;
        return OptionalInt.of(integer);
    }

    @Override
    public boolean getPermission(@Nonnull ServerPlayer player, @Nonnull IPermissionNodeAPI<Boolean> node) {
        Boolean bool;
        PermissionNode<?> forgeNode = REGISTERED_NODES.get(node);
        if (forgeNode == null) {
            return false;
        }
        Object value = PermissionAPI.getPermission((ServerPlayer)player, forgeNode, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        return value instanceof Boolean && (bool = (Boolean)value) != false;
    }

    @Override
    @Nonnull
    public <T> Optional<T> getPermissionTyped(@Nonnull ServerPlayer player, @Nonnull IPermissionNodeAPI<T> node) {
        PermissionNode<?> forgeNode = REGISTERED_NODES.get(node);
        if (forgeNode == null) {
            return Optional.empty();
        }
        Object value = PermissionAPI.getPermission((ServerPlayer)player, forgeNode, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        return Optional.ofNullable(value);
    }

    public static void registerNodes(PermissionGatherEvent.Nodes event) {
        UsedPermissionNodes.ALL.values().stream().map(ForgePermissionsSystem::convertNode).filter(Objects::nonNull).map(ForgePermissionsSystem::onRegister).forEach(xva$0 -> event.addNodes(new PermissionNode[]{xva$0}));
    }

    private static <T> Pair<IPermissionNodeAPI<T>, PermissionNode<T>> convertNode(IPermissionNodeAPI<T> node) {
        PermissionType type;
        Object object = node.getType() == Integer.class ? PermissionTypes.INTEGER : (node.getType() == Boolean.class ? PermissionTypes.BOOLEAN : (node.getType() == String.class ? PermissionTypes.STRING : (type = node.getType() == Component.class ? PermissionTypes.COMPONENT : null)));
        if (type == null) {
            OpenPartiesAndClaims.LOGGER.warn("Unimplemented node type for the Forge Permissions API: " + String.valueOf(node.getType()));
            return null;
        }
        return Pair.of(node, (Object)new PermissionNode("openpartiesandclaims", node.getDefaultNodeString(), type, (player, uuid, context) -> null, new PermissionDynamicContextKey[0]));
    }

    public static <T> PermissionNode<T> onRegister(Pair<IPermissionNodeAPI<T>, PermissionNode<T>> node) {
        REGISTERED_NODES.put((IPermissionNodeAPI)node.getLeft(), (PermissionNode)node.getRight());
        return (PermissionNode)node.getRight();
    }
}

