/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.io.FileIOHelper;
import xaero.pac.common.server.io.FilePathConfig;
import xaero.pac.common.server.io.IOThreadWorker;
import xaero.pac.common.server.io.ObjectManagerIOManager;
import xaero.pac.common.server.io.ObjectManagerIOObject;
import xaero.pac.common.server.io.exception.IOThreadWorkerException;
import xaero.pac.common.server.io.serialization.SerializationHandler;
import xaero.pac.common.server.io.serialization.SerializedDataFileIO;

public abstract class ObjectManagerIO<S, I, T extends ObjectManagerIOObject, M extends ObjectManagerIOManager<T, M>> {
    private final int MAX_PER_TICK = 5;
    protected final M manager;
    protected final String fileExtension;
    protected final SerializationHandler<S, I, T, M> serializationHandler;
    private final SerializedDataFileIO<S, I> serializedDataFileIO;
    private final IOThreadWorker ioThreadWorker;
    protected final MinecraftServer server;
    private final FileIOHelper fileIOHelper;

    protected ObjectManagerIO(SerializationHandler<S, I, T, M> serializationHandler, SerializedDataFileIO<S, I> serializedDataFileIO, IOThreadWorker ioThreadWorker, MinecraftServer server, String fileExtension, M manager, FileIOHelper fileIOHelper) {
        this.serializationHandler = serializationHandler;
        this.serializedDataFileIO = serializedDataFileIO;
        this.ioThreadWorker = ioThreadWorker;
        this.server = server;
        this.fileExtension = fileExtension;
        this.manager = manager;
        this.fileIOHelper = fileIOHelper;
    }

    protected abstract Stream<FilePathConfig> getObjectFolderPaths();

    public void load() {
        Stream<FilePathConfig> folderPaths = this.getObjectFolderPaths();
        folderPaths.forEach(folderPathConfig -> this.loadInFolder(folderPathConfig.getPath(), (FilePathConfig)folderPathConfig));
    }

    private void loadInFolder(Path folderPath, FilePathConfig filePathConfig) {
        block15: {
            try {
                Files.createDirectories(folderPath, new FileAttribute[0]);
                try (Stream<Path> contents = Files.list(folderPath);){
                    contents.forEach(fd -> {
                        if (Files.isDirectory(fd, new LinkOption[0])) {
                            return;
                        }
                        T loadedObject = this.loadFile((Path)fd, filePathConfig, true);
                        if (loadedObject != null) {
                            this.onObjectLoad(loadedObject);
                        }
                    });
                }
                if (!filePathConfig.isLoadRecursively()) break block15;
                contents = Files.list(folderPath);
                try {
                    contents.forEach(fd -> {
                        if (!Files.isDirectory(fd, new LinkOption[0])) {
                            return;
                        }
                        this.loadInFolder((Path)fd, filePathConfig);
                    });
                }
                finally {
                    if (contents != null) {
                        contents.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected abstract void onObjectLoad(T var1);

    protected abstract I getObjectId(String var1, Path var2, FilePathConfig var3);

    protected T loadFile(Path file, FilePathConfig filePathConfig, boolean backupOnError) {
        String fileName = file.getFileName().toString();
        if (!fileName.endsWith(this.fileExtension)) {
            return null;
        }
        I id = this.getObjectId(fileName.substring(0, fileName.lastIndexOf(46)), file, filePathConfig);
        try {
            Object serializedData = this.ioThreadWorker.get(() -> ObjectManagerIO.readSerializedData(id, file, this.serializedDataFileIO, 20));
            T object = this.serializationHandler.deserialize(id, this.manager, serializedData);
            return object;
        }
        catch (Throwable e) {
            if (e instanceof CompletionException && e.getCause() instanceof IOException) {
                throw e;
            }
            OpenPartiesAndClaims.LOGGER.error(String.format("Exception loading data from file %s", fileName), e);
            if (!(!backupOnError || e instanceof CompletionException && e.getCause() instanceof IOThreadWorkerException)) {
                this.ioThreadWorker.get(() -> {
                    int backupAttempts = 5;
                    while (true) {
                        try {
                            Path backupPath = this.fileIOHelper.quickFileBackupMove(file);
                            OpenPartiesAndClaims.LOGGER.error(String.format("The file was ignored and backed up to %s", backupPath));
                        }
                        catch (IOException e2) {
                            if (--backupAttempts <= 0) {
                                OpenPartiesAndClaims.LOGGER.error(String.format("IO Exception trying to backup unusable file %s", fileName), (Throwable)e2);
                                throw e;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                    return true;
                });
            }
            return null;
        }
    }

    public boolean save() {
        Iterator iter = this.manager.getToSave().iterator();
        int saves = 0;
        long before = System.currentTimeMillis();
        while (iter.hasNext()) {
            if (saves++ >= 5 || saves > 1 && System.currentTimeMillis() - before > 10L) {
                return false;
            }
            ObjectManagerIOObject object = (ObjectManagerIOObject)iter.next();
            iter.remove();
            if (!object.isDirty()) continue;
            Path filePath = this.getFilePath(object, object.getFileName());
            this.saveFile(object, filePath);
        }
        return true;
    }

    protected abstract Path getFilePath(T var1, String var2);

    protected void saveFile(T object, Path filePath) {
        object.setDirty(false);
        try {
            S serializedData = this.serializationHandler.serialize(object);
            this.ioThreadWorker.enqueue(() -> {
                try {
                    ObjectManagerIO.writeSerializedData(filePath, this.serializedDataFileIO, serializedData, this.fileIOHelper, 20);
                }
                catch (Throwable e) {
                    OpenPartiesAndClaims.LOGGER.error(String.format("Exception saving data to file %s", filePath.getFileName().toString()), e);
                }
            });
        }
        catch (Throwable e) {
            OpenPartiesAndClaims.LOGGER.error(String.format("Exception saving data to file %s", filePath.getFileName().toString()), e);
        }
    }

    public void onServerTick() {
    }

    public void delete(T object) {
        Path filePath = this.getFilePath(object, object.getFileName());
        this.ioThreadWorker.enqueue(() -> {
            try {
                ObjectManagerIO.tryToDelete(filePath, 20);
            }
            catch (Throwable e) {
                OpenPartiesAndClaims.LOGGER.error(String.format("Exception deleting file %s", filePath.getFileName().toString()), e);
            }
        });
    }

    private static void tryToDelete(Path filePath, int extraAttempts) throws IOException {
        try {
            Files.deleteIfExists(filePath);
        }
        catch (IOException e) {
            if (extraAttempts == 0) {
                OpenPartiesAndClaims.LOGGER.error("IO exception while trying to delete data", (Throwable)e);
                throw e;
            }
            OpenPartiesAndClaims.LOGGER.info("IO exception while trying to delete data at " + String.valueOf(filePath));
            OpenPartiesAndClaims.LOGGER.info("Retrying... Attempts left: " + extraAttempts);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e1) {
                OpenPartiesAndClaims.LOGGER.warn("Wait interrupted...", (Throwable)e1);
            }
            ObjectManagerIO.tryToDelete(filePath, extraAttempts - 1);
        }
    }

    private static <S, I> S readSerializedData(I id, Path fd, SerializedDataFileIO<S, I> serializedDataFileIO, int extraAttempts) {
        S serializedData;
        try (FileInputStream fileInput = new FileInputStream(fd.toFile());
             BufferedInputStream bufferedInput = new BufferedInputStream(fileInput);){
            serializedData = serializedDataFileIO.read(id, bufferedInput);
        }
        catch (IOException e) {
            if (extraAttempts == 0) {
                OpenPartiesAndClaims.LOGGER.error("IO exception while trying to load data", (Throwable)e);
                throw new RuntimeException(e);
            }
            OpenPartiesAndClaims.LOGGER.info("IO exception while trying to load data from " + String.valueOf(fd));
            OpenPartiesAndClaims.LOGGER.info("Retrying... Attempts left: " + extraAttempts);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e1) {
                OpenPartiesAndClaims.LOGGER.warn("Wait interrupted...", (Throwable)e1);
            }
            serializedData = ObjectManagerIO.readSerializedData(id, fd, serializedDataFileIO, extraAttempts - 1);
        }
        return serializedData;
    }

    private static <S, I> void writeSerializedData(Path fd, SerializedDataFileIO<S, I> serializedDataFileIO, S serializedData, FileIOHelper fileIOHelper, int extraAttempts) throws IOException {
        Path tempPath = fd.resolveSibling(fd.getFileName().toString() + ".temp");
        try {
            Files.createDirectories(fd.getParent(), new FileAttribute[0]);
            try (FileOutputStream fileOutput = new FileOutputStream(tempPath.toFile());
                 BufferedOutputStream bufferedOutput = new BufferedOutputStream(fileOutput);){
                serializedDataFileIO.write(bufferedOutput, serializedData);
                fileIOHelper.safeMoveAndReplace(tempPath, fd, true);
            }
        }
        catch (IOException e) {
            if (extraAttempts == 0) {
                OpenPartiesAndClaims.LOGGER.error("IO exception while trying to save data", (Throwable)e);
                throw e;
            }
            OpenPartiesAndClaims.LOGGER.info("IO exception while trying to save data to " + String.valueOf(fd));
            OpenPartiesAndClaims.LOGGER.info("Retrying... Attempts left: " + extraAttempts);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e1) {
                OpenPartiesAndClaims.LOGGER.warn("Wait interrupted...", (Throwable)e1);
            }
            ObjectManagerIO.writeSerializedData(fd, serializedDataFileIO, serializedData, fileIOHelper, extraAttempts - 1);
        }
    }

    public static abstract class Builder<S, I, T extends ObjectManagerIOObject, M extends ObjectManagerIOManager<T, M>, B extends Builder<S, I, T, M, B>> {
        protected B self = this;
        protected String fileExtension;
        protected SerializationHandler<S, I, T, M> serializationHandler;
        protected SerializedDataFileIO<S, I> serializedDataFileIO;
        protected IOThreadWorker ioThreadWorker;
        protected MinecraftServer server;
        protected FileIOHelper fileIOHelper;
        protected M manager;

        protected Builder() {
        }

        public B setFileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
            return this.self;
        }

        public B setSerializationHandler(SerializationHandler<S, I, T, M> serializationHandler) {
            this.serializationHandler = serializationHandler;
            return this.self;
        }

        public B setSerializedDataFileIO(SerializedDataFileIO<S, I> serializedDataFileIO) {
            this.serializedDataFileIO = serializedDataFileIO;
            return this.self;
        }

        public B setIoThreadWorker(IOThreadWorker ioThreadWorker) {
            this.ioThreadWorker = ioThreadWorker;
            return this.self;
        }

        public B setServer(MinecraftServer server) {
            this.server = server;
            return this.self;
        }

        public B setFileIOHelper(FileIOHelper fileIOHelper) {
            this.fileIOHelper = fileIOHelper;
            return this.self;
        }

        public B setManager(M manager) {
            this.manager = manager;
            return this.self;
        }

        public B setDefault() {
            this.setFileExtension(null);
            this.setSerializationHandler(null);
            this.setSerializedDataFileIO(null);
            this.setIoThreadWorker(null);
            this.setServer(null);
            this.setFileIOHelper(null);
            this.setManager(null);
            return this.self;
        }

        public ObjectManagerIO<S, I, T, M> build() {
            if (this.fileExtension == null || this.serializationHandler == null || this.serializedDataFileIO == null || this.ioThreadWorker == null || this.server == null || this.fileIOHelper == null || this.manager == null) {
                throw new IllegalStateException();
            }
            return this.buildInternally();
        }

        protected abstract ObjectManagerIO<S, I, T, M> buildInternally();
    }
}

