/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectedWindow
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST});
    public static final EnumProperty<ExtendablePart> PART = EnumProperty.create((String)"part", ExtendablePart.class);
    protected static final VoxelShape EE = ConnectedWindow.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = ConnectedWindow.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);

    public ConnectedWindow(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)ExtendablePart.BASE)));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction originalDirection = (Direction)state.getValue((Property)FACING);
        Direction rotatedDirection = rot.rotate(originalDirection);
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotatedDirection);
    }

    public BlockState mirror(BlockState state, Mirror mir) {
        Direction originalDirection = (Direction)state.getValue((Property)FACING);
        Direction rotatedDirection = mir == Mirror.FRONT_BACK ? originalDirection : originalDirection.getOpposite();
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotatedDirection);
    }

    protected BlockState WindowState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean below = level.getBlockState(pos.below()).getBlock() == this;
        boolean north = level.getBlockState(pos.north()).getBlock() == this;
        boolean east = level.getBlockState(pos.east()).getBlock() == this;
        boolean south = level.getBlockState(pos.south()).getBlock() == this;
        boolean west = level.getBlockState(pos.west()).getBlock() == this;
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                if (!above && below) {
                    if (east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.TOP_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.TOP_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.TOP_R));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.TOP));
                }
                if (above && below) {
                    if (east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MID_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MID_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MID_R));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MIDDLE));
                }
                if (above && !below) {
                    if (east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BOT_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BOT_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BOT_R));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BOTTOM));
                }
                if (!above && !below) {
                    if (east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.SINGLE_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.SINGLE_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.SINGLE_R));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BASE));
                }
            }
            case EAST: {
                if (!above && below) {
                    if (north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.TOP_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.TOP_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.TOP_L));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.TOP));
                }
                if (above && below) {
                    if (north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MID_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MID_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MID_L));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.MIDDLE));
                }
                if (above && !below) {
                    if (north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BOT_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BOT_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BOT_L));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BOTTOM));
                }
                if (above || below) break;
                if (north && south) {
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.SINGLE_M));
                }
                if (!north && south) {
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.SINGLE_R));
                }
                if (north && !south) {
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.SINGLE_L));
                }
                return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BASE));
            }
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)ExtendablePart.BASE));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        BlockState newState;
        if (state.hasProperty((Property)FACING) && statetwo.hasProperty((Property)FACING) && !statetwo.is((newState = (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)statetwo.getValue((Property)FACING)))).getBlock())) {
            level.setBlock(pos, this.WindowState(newState, (LevelAccessor)level, pos), 2);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        Direction facingDirection = contx.getHorizontalDirection();
        if (facingDirection == Direction.WEST) {
            facingDirection = Direction.EAST;
        } else if (facingDirection == Direction.SOUTH) {
            facingDirection = Direction.NORTH;
        }
        return (BlockState)this.WindowState(super.getStateForPlacement(contx), (LevelAccessor)contx.getLevel(), contx.getClickedPos()).setValue((Property)FACING, (Comparable)facingDirection);
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.setBlock(pos, this.defaultBlockState(), num);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.WindowState(state, level, pos);
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == ItemInit.HAMMER.get()) {
            state = (BlockState)state.cycle(PART);
            level.setBlock(pos, state, 1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? NN : EE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING});
    }

    public static enum ExtendablePart implements StringRepresentable
    {
        BASE("base"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom"),
        TOP_L("top_l"),
        TOP_M("top_m"),
        TOP_R("top_r"),
        MID_L("mid_l"),
        MID_M("mid_m"),
        MID_R("mid_r"),
        BOT_L("bot_l"),
        BOT_M("bot_m"),
        BOT_R("bot_r"),
        SINGLE_L("single_l"),
        SINGLE_M("single_m"),
        SINGLE_R("single_r");

        private final String name;

        private ExtendablePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

