/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.init.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AwningBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public AwningBlock(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        return BASE;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.getAxis().isHorizontal() ? (BlockState)stateIn.setValue(SHAPE, (Comparable)AwningBlock.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos)) : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.cycle(SHAPE);
            world.setBlock(pos, state, 2);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Direction horizontalDirection = context.getHorizontalDirection();
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)horizontalDirection);
        return (BlockState)blockstate.setValue(SHAPE, (Comparable)AwningBlock.getShapeProperty(blockstate, (BlockGetter)context.getLevel(), blockpos));
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState blockstate = worldIn.getBlockState(pos.relative(direction));
        if (AwningBlock.isBlockStairs(blockstate) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != direction.getAxis()) {
            return direction1 == direction.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.getBlockState(pos.relative(direction.getOpposite()));
        if (AwningBlock.isBlockStairs(blockstate1) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != direction.getAxis()) {
            return direction2 == direction.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.getBlock() instanceof AwningBlock;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.getValue(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)this.getMirroredShape(stairsshape));
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)this.getMirroredShape(stairsshape));
            }
        }
        return super.mirror(state, mirrorIn);
    }

    private StairsShape getMirroredShape(StairsShape shape) {
        switch (shape) {
            case INNER_LEFT: {
                return StairsShape.INNER_RIGHT;
            }
            case INNER_RIGHT: {
                return StairsShape.INNER_LEFT;
            }
            case OUTER_LEFT: {
                return StairsShape.OUTER_RIGHT;
            }
            case OUTER_RIGHT: {
                return StairsShape.OUTER_LEFT;
            }
        }
        return shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE});
    }
}

