/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GutterTall
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape[] SHAPES = new VoxelShape[12];
    public static final BooleanProperty ABOVE;
    public static final BooleanProperty BELOW;
    private static final BooleanProperty WATER;

    public GutterTall(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATER, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ABOVE, (Comparable)Boolean.valueOf(false))).setValue((Property)BELOW, (Comparable)Boolean.valueOf(false)));
    }

    private BlockState GutterState(BlockState state, LevelAccessor access, BlockPos pos) {
        boolean above = access.getBlockState(pos.above()).getBlock() == this;
        boolean below = access.getBlockState(pos.below()).getBlock() == this;
        return (BlockState)((BlockState)state.setValue((Property)ABOVE, (Comparable)Boolean.valueOf(above))).setValue((Property)BELOW, (Comparable)Boolean.valueOf(below));
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState statetwo, boolean bolean) {
        if (!statetwo.is(state.getBlock())) {
            this.GutterState(state, (LevelAccessor)world, pos);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable Entity entity, ItemStack stack) {
        this.GutterState(state, (LevelAccessor)world, pos);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState bstate, LevelAccessor world, BlockPos pos, BlockPos postwo) {
        return this.GutterState(state, world, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.GutterState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos()).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    public void placeAt(Level world, BlockPos pos, int into) {
        world.setBlock(pos, this.defaultBlockState(), into);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        Direction facing;
        boolean isBelow;
        boolean isAbove = (Boolean)state.getValue((Property)ABOVE);
        int shapeIndex = this.getShapeIndex(isAbove, isBelow = ((Boolean)state.getValue((Property)BELOW)).booleanValue(), facing = (Direction)state.getValue((Property)FACING));
        if (shapeIndex >= 0 && shapeIndex < SHAPES.length) {
            return SHAPES[shapeIndex];
        }
        return Shapes.empty();
    }

    private int getShapeIndex(boolean isAbove, boolean isBelow, Direction facing) {
        if (!isAbove && !isBelow) {
            switch (facing) {
                case WEST: {
                    return 2;
                }
                case EAST: {
                    return 0;
                }
                case SOUTH: {
                    return 1;
                }
                case NORTH: {
                    return 3;
                }
            }
        } else if (isAbove && isBelow) {
            switch (facing) {
                case WEST: {
                    return 6;
                }
                case EAST: {
                    return 4;
                }
                case SOUTH: {
                    return 5;
                }
                case NORTH: {
                    return 7;
                }
            }
        } else if (isAbove && !isBelow) {
            switch (facing) {
                case WEST: {
                    return 2;
                }
                case EAST: {
                    return 0;
                }
                case SOUTH: {
                    return 1;
                }
                case NORTH: {
                    return 3;
                }
            }
        } else {
            switch (facing) {
                case WEST: {
                    return 10;
                }
                case EAST: {
                    return 8;
                }
                case SOUTH: {
                    return 9;
                }
                case NORTH: {
                    return 11;
                }
            }
        }
        return -1;
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = itemstack.getItem();
        Boolean i = (Boolean)state.getValue((Property)WATER);
        if (item == Items.WATER_BUCKET && !i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            itemstack.shrink(1);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
        }
        if (item == Items.BUCKET && i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            itemstack.shrink(1);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.WATER_BUCKET));
        }
        if (item == Items.GLASS_BOTTLE && i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.POTION));
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.levelEvent(1029, pos, 0);
    }

    protected boolean isRainingday(Level world, BlockPos pos) {
        return world.isRainingAt(pos);
    }

    public boolean isRandomlyTicking(BlockState state) {
        if (((Boolean)state.getValue((Property)WATER)).booleanValue()) {
            // empty if block
        }
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.above(30);
        if (world.isRainingAt(blockpos) && !((Boolean)state.getValue((Property)WATER)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(true)));
        }
        if (!world.isRainingAt(blockpos) && ((Boolean)state.getValue((Property)WATER)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(false)));
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ABOVE, BELOW, WATER});
    }

    static {
        GutterTall.SHAPES[0] = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)0.0, (double)9.8, (double)16.0, (double)4.0), (VoxelShape)Block.box((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)4.0, (double)8.0));
        GutterTall.SHAPES[1] = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)9.8), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)6.0, (double)12.0, (double)4.0, (double)9.9));
        GutterTall.SHAPES[2] = Shapes.or((VoxelShape)Block.box((double)6.2, (double)0.0, (double)12.0, (double)10.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)6.1, (double)0.0, (double)8.0, (double)10.0, (double)4.0, (double)12.0));
        GutterTall.SHAPES[3] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)6.2, (double)4.0, (double)16.01, (double)10.0), (VoxelShape)Block.box((double)4.0, (double)0.0, (double)6.1, (double)8.0, (double)4.0, (double)10.0));
        GutterTall.SHAPES[4] = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)0.0, (double)9.8, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[5] = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)9.8), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[6] = Shapes.or((VoxelShape)Block.box((double)6.2, (double)0.0, (double)12.0, (double)10.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[7] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)6.2, (double)4.0, (double)16.01, (double)10.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[8] = Shapes.or((VoxelShape)Block.box((double)5.0, (double)9.0, (double)2.8, (double)11.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), Block.box((double)6.0, (double)0.0, (double)0.0, (double)9.8, (double)11.4, (double)4.0)});
        GutterTall.SHAPES[9] = Shapes.or((VoxelShape)Block.box((double)7.0, (double)9.0, (double)5.1, (double)13.2, (double)16.0, (double)11.1), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)11.0, (double)0.1, (double)16.0, (double)15.0, (double)16.1), Block.box((double)12.0, (double)0.0, (double)6.1, (double)16.0, (double)11.4, (double)9.9)});
        GutterTall.SHAPES[10] = Shapes.or((VoxelShape)Block.box((double)4.9, (double)9.0, (double)7.0, (double)10.9, (double)16.0, (double)13.2), (VoxelShape[])new VoxelShape[]{Block.box((double)-0.1, (double)11.0, (double)12.0, (double)15.9, (double)15.0, (double)16.0), Block.box((double)6.1, (double)0.0, (double)12.0, (double)9.9, (double)11.4, (double)16.0)});
        GutterTall.SHAPES[11] = Shapes.or((VoxelShape)Block.box((double)2.8, (double)9.0, (double)4.9, (double)9.0, (double)16.0, (double)10.9), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)11.0, (double)-0.1, (double)4.0, (double)15.0, (double)15.9), Block.box((double)0.0, (double)0.0, (double)6.1, (double)4.0, (double)11.4, (double)9.9)});
        ABOVE = BooleanProperty.create((String)"above");
        BELOW = BooleanProperty.create((String)"below");
        WATER = BooleanProperty.create((String)"water");
    }
}

