/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.objects.LightBaseTall;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TikiTorch
extends LightBaseTall {
    protected final ParticleOptions flame;
    private static final VoxelShape BASE = Block.box((double)6.0, (double)0.1, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BASE;
    }

    public TikiTorch(BlockBehaviour.Properties properties, ParticleOptions flame) {
        super(properties);
        this.flame = flame;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.BOTTOM))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        LightBaseTall.LightPart part = (LightBaseTall.LightPart)((Object)state.getValue((Property)PART));
        Boolean lit = (Boolean)state.getValue((Property)LIT);
        Item item = itemstack.getItem();
        if (item != this.asItem()) {
            if (!worldIn.isClientSide() && part == LightBaseTall.LightPart.BOTTOM || part == LightBaseTall.LightPart.MIDDLE) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (part == LightBaseTall.LightPart.TOP || part == LightBaseTall.LightPart.BASE) {
                state = (BlockState)state.cycle((Property)LIT);
                worldIn.setBlock(pos, state, 10);
                if (!lit.booleanValue()) {
                    worldIn.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
                } else {
                    worldIn.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
                }
                worldIn.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
                return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
            }
            return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, LIT, POWERED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 1.0;
        double d2 = (double)pos.getZ() + 0.5;
        Boolean i = (Boolean)stateIn.getValue((Property)LIT);
        LightBaseTall.LightPart part = (LightBaseTall.LightPart)((Object)stateIn.getValue((Property)PART));
        if (i.booleanValue() && part == LightBaseTall.LightPart.BASE) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            worldIn.addParticle(this.flame, d0, d1, d2, 0.0, 0.0, 0.0);
        }
        if (i.booleanValue() && part == LightBaseTall.LightPart.TOP) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            worldIn.addParticle(this.flame, d0, d1, d2, 0.0, 0.0, 0.0);
        }
        if (!i.booleanValue()) {
            return;
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(state, (LevelReader)world, currentPos)) {
            world.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = world.getBlockState(belowPos);
        boolean belowMaterial = !belowState.isAir();
        FluidState belowFluidState = world.getFluidState(belowPos);
        return belowMaterial || belowFluidState.is(FluidTags.LAVA);
    }
}

