/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects.items;

import com.mcwbridges.kikoz.objects.Bridge_Block;
import com.mcwbridges.kikoz.objects.Bridge_Block_Rope;
import com.mcwbridges.kikoz.objects.Bridge_Stairs;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Torch
extends HorizontalDirectionalBlock {
    public static final EnumProperty<LightState> LIGHTSTATE = EnumProperty.create((String)"lightstate", LightState.class);
    protected static final VoxelShape EAST = Block.box((double)6.2, (double)0.0, (double)0.0, (double)9.8, (double)8.0, (double)2.8);
    protected static final VoxelShape SOUTH = Block.box((double)13.2, (double)0.0, (double)6.2, (double)16.0, (double)8.0, (double)9.8);
    protected static final VoxelShape WEST = Block.box((double)6.2, (double)0.0, (double)13.2, (double)9.8, (double)8.0, (double)16.0);
    protected static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)6.2, (double)2.8, (double)8.0, (double)9.8);
    protected static final VoxelShape EAST_STAIR = Block.box((double)6.2, (double)6.0, (double)0.0, (double)9.8, (double)16.0, (double)2.8);
    protected static final VoxelShape SOUTH_STAIR = Block.box((double)13.2, (double)6.0, (double)6.2, (double)16.0, (double)16.0, (double)9.8);
    protected static final VoxelShape WEST_STAIR = Block.box((double)6.2, (double)6.0, (double)13.2, (double)9.8, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_STAIR = Block.box((double)0.0, (double)6.0, (double)6.2, (double)2.8, (double)16.0, (double)9.8);
    protected int lightValue;

    public Bridge_Torch(BlockBehaviour.Properties prop, int lightValue) {
        super(prop);
        this.lightValue = lightValue;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(LIGHTSTATE, (Comparable)((Object)LightState.BRIDGE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        LightState lightState = (LightState)((Object)state.getValue(LIGHTSTATE));
        if (lightState == LightState.BRIDGE) {
            switch (facing) {
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
            }
            return EAST;
        }
        switch (facing) {
            case NORTH: {
                return NORTH_STAIR;
            }
            case SOUTH: {
                return SOUTH_STAIR;
            }
            case WEST: {
                return WEST_STAIR;
            }
        }
        return EAST_STAIR;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        return Shapes.empty();
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean bool) {
        if (fromPos.above().equals((Object)pos) && !level.getBlockState(pos.below()).isCollisionShapeFullBlock((BlockGetter)level, pos.below())) {
            level.destroyBlock(pos, true);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.lightValue;
    }

    public int getLightValue(BlockState state, BlockGetter reader, BlockPos pos) {
        return 15;
    }

    public float getAmbientOcclusionLightValue(BlockState state, BlockGetter reader, BlockPos pos) {
        return 1.0f;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIGHTSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        Bridge_Block.ConnectionStatus connectionStatus;
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)contx.getHorizontalDirection().getClockWise());
        BlockPos belowPos = contx.getClickedPos().below();
        BlockState belowState = contx.getLevel().getBlockState(belowPos);
        if (belowState.getBlock() instanceof Bridge_Block ? (connectionStatus = (Bridge_Block.ConnectionStatus)((Object)belowState.getValue(Bridge_Block.CONNECTION))) == Bridge_Block.ConnectionStatus.BASE || connectionStatus == Bridge_Block.ConnectionStatus.BASE_TOGGLED : (belowState.getBlock() instanceof Bridge_Block_Rope ? (connectionStatus = (Bridge_Block_Rope.ConnectionStatus)((Object)belowState.getValue(Bridge_Block_Rope.CONNECTION))) == Bridge_Block_Rope.ConnectionStatus.BASE || connectionStatus == Bridge_Block_Rope.ConnectionStatus.BASE_TOGGLED : belowState.getBlock() instanceof Bridge_Stairs && ((connectionStatus = (Bridge_Stairs.ConnectionStatus)((Object)belowState.getValue(Bridge_Stairs.CONNECTION))) == Bridge_Stairs.ConnectionStatus.BASE || connectionStatus == Bridge_Stairs.ConnectionStatus.DOUBLE))) {
            return null;
        }
        return (BlockState)state.setValue(LIGHTSTATE, (Comparable)((Object)LightState.byState(belowState)));
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return dir == Direction.DOWN ? (BlockState)state.setValue(LIGHTSTATE, (Comparable)((Object)LightState.byState(statetwo))) : super.updateShape(state, dir, statetwo, access, pos, postwo);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public static enum LightState implements StringRepresentable
    {
        BRIDGE("bridge"),
        STAIR("stair");

        private final String name;

        private LightState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static LightState byState(BlockState state) {
            if (state.getBlock() instanceof Bridge_Stairs) {
                return STAIR;
            }
            return BRIDGE;
        }
    }
}

