/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    @Override
    public void render(GuiGraphics guiGraphics, @Nullable ItemStack ingredient) {
        if (ingredient != null) {
            RenderSystem.enableDepthTest();
            Minecraft minecraft = Minecraft.getInstance();
            Font font = this.getFontRenderer(minecraft, ingredient);
            guiGraphics.renderFakeItem(ingredient, 0, 0);
            guiGraphics.renderItemDecorations(font, ingredient, 0, 0);
            RenderSystem.disableBlend();
        }
    }

    @Override
    public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        return ingredient.getTooltipLines(Item.TooltipContext.EMPTY, (Player)player, tooltipFlag);
    }

    @Override
    public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getFontRenderer(minecraft, ingredient);
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public int getHeight() {
        return 16;
    }
}

