/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryWrapper<T> {
    private final Registry<T> registry;

    public static <T> RegistryWrapper<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        RegistryWrapper<T> registryWrapper;
        Registry rootRegistry = BuiltInRegistries.REGISTRY;
        Registry registry = (Registry)rootRegistry.get(key.location());
        if (registry == null) {
            throw new NullPointerException("Could not find registry for key: " + String.valueOf(key));
        }
        RegistryWrapper<T> castPlatformRegistry = registryWrapper = new RegistryWrapper<T>(registry);
        return castPlatformRegistry;
    }

    private RegistryWrapper(Registry<T> registry) {
        this.registry = registry;
    }

    public Stream<T> getValues() {
        return this.registry.stream();
    }

    public Stream<Holder.Reference<T>> getHolderStream() {
        return this.registry.holders();
    }

    public boolean contains(T entry) {
        return this.registry.getKey(entry) != null;
    }

    public Optional<ResourceLocation> getRegistryName(T entry) {
        return this.registry.getResourceKey(entry).map(ResourceKey::location);
    }
}

