/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.keys;

import com.mojang.blaze3d.platform.InputConstants;
import mezz.jei.common.input.keys.JeiKeyConflictContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public enum JeiKeyModifier {
    CONTROL_OR_COMMAND{

        @Override
        public boolean isActive(JeiKeyConflictContext context) {
            return Screen.hasControlDown();
        }

        @Override
        public Component getCombinedName(InputConstants.Key key) {
            if (Minecraft.ON_OSX) {
                return Component.translatable((String)"jei.key.combo.command", (Object[])new Object[]{key.getDisplayName()});
            }
            return Component.translatable((String)"jei.key.combo.control", (Object[])new Object[]{key.getDisplayName()});
        }
    }
    ,
    SHIFT{

        @Override
        public boolean isActive(JeiKeyConflictContext context) {
            return Screen.hasShiftDown();
        }

        @Override
        public Component getCombinedName(InputConstants.Key key) {
            return Component.translatable((String)"jei.key.combo.shift", (Object[])new Object[]{key.getDisplayName()});
        }
    }
    ,
    ALT{

        @Override
        public boolean isActive(JeiKeyConflictContext context) {
            return Screen.hasAltDown();
        }

        @Override
        public Component getCombinedName(InputConstants.Key key) {
            return Component.translatable((String)"jei.key.combo.alt", (Object[])new Object[]{key.getDisplayName()});
        }
    }
    ,
    NONE{

        @Override
        public boolean isActive(JeiKeyConflictContext context) {
            if (context.conflicts(JeiKeyConflictContext.IN_GAME)) {
                return true;
            }
            return !CONTROL_OR_COMMAND.isActive(context) && !SHIFT.isActive(context) && !ALT.isActive(context);
        }

        @Override
        public Component getCombinedName(InputConstants.Key key) {
            return key.getDisplayName();
        }
    };


    public abstract boolean isActive(JeiKeyConflictContext var1);

    public abstract Component getCombinedName(InputConstants.Key var1);
}

