var Opcodes=Java.type('org.objectweb.asm.Opcodes')
var InsnList=Java.type('org.objectweb.asm.tree.InsnList')
var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
var MethodNode=Java.type('org.objectweb.asm.tree.MethodNode')
var InsnNode=Java.type('org.objectweb.asm.tree.InsnNode')
var FieldInsnNode=Java.type('org.objectweb.asm.tree.FieldInsnNode')
var LabelNode=Java.type('org.objectweb.asm.tree.LabelNode')
var LocalVariableNode=Java.type('org.objectweb.asm.tree.LocalVariableNode')
var Label=Java.type('org.objectweb.asm.Label')
var JumpInsnNode=Java.type('org.objectweb.asm.tree.JumpInsnNode')
var FieldNode=Java.type('org.objectweb.asm.tree.FieldNode')

function insertBeforeReturn(methodNode, patchList){
    var instructions = methodNode.instructions
    for(var i = instructions.size() - 1; i >= 0; i--){
        if(instructions.get(i).getOpcode() >= 172 && instructions.get(i).getOpcode() <= 177)
            instructions.insertBefore(instructions.get(i), patchList)
    }
}

function initializeCoreMod() {
    return {
        'xaero_platform_gui_render': {
            'target' : {
                'type' : 'METHOD',
                'class' : 'net.minecraft.client.gui.Gui',
                'methodName' : 'render',
                'methodDesc' : '(Lnet/minecraft/client/gui/GuiGraphics;F)V'
            },
            'transformer' : function(methodNode){
                var instructions = methodNode.instructions
                var patchList = new InsnList()
                patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
                patchList.add(new VarInsnNode(Opcodes.FLOAD, 2))
                patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore',
                        "beforeIngameGuiRender", "(Lnet/minecraft/client/gui/GuiGraphics;F)V"))
                instructions.insert(instructions.get(0), patchList)

                patchList = new InsnList()
                patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
                patchList.add(new VarInsnNode(Opcodes.FLOAD, 2))
                patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore',
                        "afterIngameGuiRender", "(Lnet/minecraft/client/gui/GuiGraphics;F)V"))
                insertBeforeReturn(methodNode, patchList)
                return methodNode
            }
        },
        'xaero_platform_gui_rendereffects': {
            'target' : {
                'type' : 'METHOD',
                'class' : 'net.minecraft.client.gui.Gui',
                'methodName' : 'renderEffects',
                'methodDesc' : '(Lnet/minecraft/client/gui/GuiGraphics;F)V'
            },
            'transformer' : function(methodNode){
                var instructions = methodNode.instructions
                var patchList = new InsnList()
                var MY_LABEL = new LabelNode(new Label())
                patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
                patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore',
                        "onRenderStatusEffectOverlay", "(Lnet/minecraft/client/gui/GuiGraphics;)Z"))
                patchList.add(new JumpInsnNode(Opcodes.IFEQ, MY_LABEL))
                patchList.add(new InsnNode(Opcodes.RETURN))
                patchList.add(MY_LABEL)
                instructions.insert(instructions.get(0), patchList)

                patchList = new InsnList()
                patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
                patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore',
                        "onRenderStatusEffectOverlayPost", "(Lnet/minecraft/client/gui/GuiGraphics;)V"))
                insertBeforeReturn(methodNode, patchList)
                return methodNode
            }
        },
        'xaero_platform_gui_rendercrosshair': {
            'target' : {
                'type' : 'METHOD',
                'class' : 'net.minecraft.client.gui.Gui',
                'methodName' : 'renderCrosshair',
                'methodDesc' : '(Lnet/minecraft/client/gui/GuiGraphics;F)V'
            },
            'transformer' : function(methodNode){
                var instructions = methodNode.instructions
                var patchList = new InsnList()
                var MY_LABEL = new LabelNode(new Label())
                patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
                patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore',
                        "onRenderCrosshair", "(Lnet/minecraft/client/gui/GuiGraphics;)Z"))
                patchList.add(new JumpInsnNode(Opcodes.IFEQ, MY_LABEL))
                patchList.add(new InsnNode(Opcodes.RETURN))
                patchList.add(MY_LABEL)
                instructions.insert(instructions.get(0), patchList)
                return methodNode
            }
        },
        'xaero_platform_gui_renderhotbaranddecor': {
            'target' : {
                'type' : 'METHOD',
                'class' : 'net.minecraft.client.gui.Gui',
                'methodName' : 'renderHotbarAndDecorations',
                'methodDesc' : '(Lnet/minecraft/client/gui/GuiGraphics;F)V'
            },
            'transformer' : function(methodNode){
                var instructions = methodNode.instructions
                var patchList = new InsnList()
                patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
                patchList.add(new VarInsnNode(Opcodes.FLOAD, 2))
                patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore',
                        "handleRenderModOverlay", "(Lnet/minecraft/client/gui/GuiGraphics;F)V"))
                instructions.insert(instructions.get(0), patchList)
                return methodNode
            }
        }
    }
}