/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import xaero.common.graphics.CustomRenderTypes;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelPartRenderTrace;

public class ModelRenderTrace {
    public final EntityModel<?> model;
    public final ResourceLocation renderTexture;
    public final TextureAtlasSprite renderAtlasSprite;
    public final CustomRenderTypes.EntityIconLayerPhases layerPhases;
    public final float red;
    public final float green;
    public final float blue;
    public final float alpha;
    public boolean allVisible;
    private HashMap<ModelPart, ModelPartRenderTrace> visibleParts;

    public ModelRenderTrace(EntityModel<?> model, ResourceLocation renderTexture, TextureAtlasSprite renderAtlasSprite, CustomRenderTypes.EntityIconLayerPhases layerPhases, float red, float green, float blue, float alpha) {
        this.model = model;
        this.renderTexture = renderTexture;
        this.renderAtlasSprite = renderAtlasSprite;
        this.layerPhases = layerPhases;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public String toString() {
        return String.valueOf(this.model) + " " + String.valueOf(this.layerPhases.texture);
    }

    public void addVisibleModelPart(ModelPart part, float red, float green, float blue, float alpha) {
        if (this.visibleParts == null) {
            this.visibleParts = new HashMap();
        }
        this.visibleParts.put(part, new ModelPartRenderTrace(part, red, green, blue, alpha));
    }

    public ModelPartRenderTrace getModelPartRenderInfo(ModelPart part) {
        ModelPartRenderTrace mprdi;
        ModelPartRenderTrace modelPartRenderTrace = mprdi = this.visibleParts == null ? null : this.visibleParts.get(part);
        if (mprdi == null && this.allVisible) {
            mprdi = new ModelPartRenderTrace(part, this.red, this.green, this.blue, this.alpha);
        }
        return mprdi;
    }

    public boolean isEmpty() {
        return !this.allVisible && (this.visibleParts == null || this.visibleParts.isEmpty());
    }

    public boolean sameVisibility(ModelRenderTrace other) {
        HashMap<ModelPart, ModelPartRenderTrace> otherVisibleParts;
        if (this.visibleParts == null != ((otherVisibleParts = other.visibleParts) == null)) {
            return false;
        }
        if (this.visibleParts == null) {
            return true;
        }
        if (this.visibleParts.size() != otherVisibleParts.size()) {
            return false;
        }
        Set<ModelPart> keySet = this.visibleParts.keySet();
        for (ModelPart key : keySet) {
            if (otherVisibleParts.containsKey(key)) continue;
            return false;
        }
        return true;
    }
}

