/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.sprite;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.lwjgl.opengl.GL11;
import xaero.hud.minimap.radar.icon.creator.RadarIconCreator;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.sprite.RadarIconSpriteForm;
import xaero.hud.render.util.DirectRender;

public class RadarIconSpriteFormPrerenderer
implements IRadarIconFormPrerenderer {
    private final boolean flipped;
    private final boolean outlined;

    public RadarIconSpriteFormPrerenderer(boolean flipped, boolean outlined) {
        this.flipped = flipped;
        this.outlined = outlined;
    }

    @Override
    public boolean requiresEntityModel() {
        return false;
    }

    @Override
    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public boolean isOutlined() {
        return this.outlined;
    }

    @Override
    public <T extends Entity> boolean prerender(GuiGraphics guiGraphics, EntityRenderer<? super T> entityRenderer, @Nullable EntityModel<T> entityModel, T entity, @Nullable List<ModelRenderTrace> traceResult, RadarIconCreator.Parameters parameters) {
        PoseStack matrixStack = guiGraphics.pose();
        RadarIconSpriteForm spriteForm = (RadarIconSpriteForm)parameters.form;
        ResourceLocation sprite = spriteForm.getSpriteLocation();
        GlStateManager._disableBlend();
        GlStateManager._enableBlend();
        GlStateManager._disableCull();
        Lighting.setupForFlatItems();
        Minecraft.getInstance().getTextureManager().bindForSetup(sprite);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        int halfIcon = 32;
        matrixStack.translate((float)halfIcon, (float)halfIcon, 1.0f);
        float scale = parameters.scale;
        if (scale < 1.0f) {
            matrixStack.scale(scale, scale, 1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DirectRender.texturedRect(matrixStack, -halfIcon, -halfIcon, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
        GlStateManager._enableCull();
        return true;
    }
}

