/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.enchant;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.enchant.IFallingTreeEnchantment;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ItemStackWrapper;
import java.util.Optional;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChopperEnchantment
extends Enchantment
implements IFallingTreeEnchantment {
    private final FallingTreeCommon<?> mod;
    private final BreakMode breakMode;

    public ChopperEnchantment(@NotNull FallingTreeCommon<?> mod, @Nullable BreakMode breakMode) {
        super(Enchantment.definition((TagKey)ItemTags.MINING_ENCHANTABLE, (int)1, (int)1, (Enchantment.Cost)ChopperEnchantment.constantCost((int)1), (Enchantment.Cost)ChopperEnchantment.constantCost((int)10), (int)1, (EquipmentSlot[])new EquipmentSlot[]{EquipmentSlot.MAINHAND}));
        this.mod = mod;
        this.breakMode = breakMode;
    }

    public boolean isTradeable() {
        return !this.mod.getConfiguration().getEnchantment().isHideEnchant();
    }

    public boolean isDiscoverable() {
        return !this.mod.getConfiguration().getEnchantment().isHideEnchant();
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack) {
        return this.mod.isValidTool(new ItemStackWrapper(stack));
    }

    protected boolean checkCompatibility(@NotNull Enchantment enchantment) {
        return super.checkCompatibility(enchantment) && !(enchantment instanceof IFallingTreeEnchantment);
    }

    @Override
    @NotNull
    public Optional<BreakMode> getBreakMode() {
        return Optional.ofNullable(this.breakMode);
    }
}

