/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.common.wrapper;

import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ItemStackWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.LevelWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ServerLevelWrapper;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class PlayerWrapper
implements IPlayer {
    @NotNull
    private final Player raw;

    @Override
    public void sendMessage(@NotNull IComponent component, @NotNull NotificationMode mode) {
        Component text = (Component)component.getRaw();
        Player player = this.raw;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            switch (mode) {
                case CHAT: {
                    serverPlayer.sendSystemMessage(text, false);
                    break;
                }
                case ACTION_BAR: {
                    serverPlayer.sendSystemMessage(text, true);
                }
            }
        } else {
            this.raw.sendSystemMessage(text);
        }
    }

    @Override
    @NotNull
    public IItemStack getMainHandItem() {
        return new ItemStackWrapper(this.raw.getMainHandItem());
    }

    @Override
    public void awardItemUsed(@NotNull IItem item) {
        this.raw.awardStat(Stats.ITEM_USED.get((Object)((Item)item.getRaw())));
    }

    @Override
    public boolean isCreative() {
        return this.raw.isCreative();
    }

    @Override
    public boolean isCrouching() {
        return this.raw.isCrouching();
    }

    @Override
    @NotNull
    public UUID getUUID() {
        return this.raw.getUUID();
    }

    @Override
    @NotNull
    public ILevel getLevel() {
        LevelWrapper levelWrapper;
        Level level = this.raw.getCommandSenderWorld();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            levelWrapper = new ServerLevelWrapper(serverLevel);
        } else {
            levelWrapper = new LevelWrapper((LevelAccessor)this.raw.getCommandSenderWorld());
        }
        return levelWrapper;
    }

    @Override
    @NotNull
    public Set<String> getTags() {
        return this.raw.getTags();
    }

    @Override
    public boolean addTag(@NotNull String tag) {
        return this.raw.addTag(tag);
    }

    @Override
    public boolean removeTag(@NotNull String tag) {
        return this.raw.removeTag(tag);
    }

    public PlayerWrapper(@NotNull Player raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    public String toString() {
        return "PlayerWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @NotNull
    public Player getRaw() {
        return this.raw;
    }
}

