/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.common.wrapper;

import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.enchant.IFallingTreeEnchantment;
import fr.rakambda.fallingtree.common.wrapper.IEnchantment;
import java.util.Optional;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public class EnchantmentWrapper
implements IEnchantment {
    @NotNull
    private final Enchantment raw;

    @NotNull
    public Enchantment getRaw() {
        return this.raw;
    }

    @Override
    @NotNull
    public Optional<BreakMode> getBreakMode() {
        Enchantment enchantment = this.getRaw();
        if (enchantment instanceof IFallingTreeEnchantment) {
            IFallingTreeEnchantment ftEnchantment = (IFallingTreeEnchantment)enchantment;
            return ftEnchantment.getBreakMode();
        }
        return Optional.empty();
    }

    public EnchantmentWrapper(@NotNull Enchantment raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    public String toString() {
        return "EnchantmentWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }
}

