/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.common.wrapper;

import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IRandomSource;
import fr.rakambda.fallingtree.common.wrapper.IServerLevel;
import fr.rakambda.fallingtree.neoforge.common.wrapper.BlockWrapper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BlockStateWrapper
implements IBlockState {
    @NotNull
    private final BlockState raw;

    @Override
    public void tick(@NotNull IServerLevel level, @NotNull IBlockPos blockPos, @NotNull IRandomSource random) {
        ServerLevel l = (ServerLevel)level.getRaw();
        BlockPos bp = (BlockPos)blockPos.getRaw();
        this.raw.tick(l, bp, (RandomSource)random.getRaw());
    }

    @Override
    public void randomTick(@NotNull IServerLevel level, @NotNull IBlockPos blockPos, @NotNull IRandomSource random) {
        ServerLevel l = (ServerLevel)level.getRaw();
        BlockPos bp = (BlockPos)blockPos.getRaw();
        this.raw.randomTick(l, bp, (RandomSource)random.getRaw());
    }

    @Override
    @NotNull
    public IBlock getBlock() {
        return new BlockWrapper(this.raw.getBlock());
    }

    @Override
    public boolean isRandomlyTicking() {
        return this.raw.isRandomlyTicking();
    }

    @Override
    @NotNull
    public Optional<Boolean> hasLeafPersistentFlag() {
        return this.raw.getOptionalValue((Property)LeavesBlock.PERSISTENT);
    }

    @Override
    public void dropResources(@NotNull ILevel level, @NotNull IBlockPos blockPos) {
        Block.dropResources((BlockState)this.raw, (Level)((Level)level.getRaw()), (BlockPos)((BlockPos)blockPos.getRaw()));
    }

    public BlockStateWrapper(@NotNull BlockState raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    public String toString() {
        return "BlockStateWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @NotNull
    public BlockState getRaw() {
        return this.raw;
    }
}

