/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.network;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.network.ConfigurationPacket;
import fr.rakambda.fallingtree.forge.network.ForgePacketHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlayerJoinListener {
    private static final Logger log = LogManager.getLogger(PlayerJoinListener.class);
    @NotNull
    private final FallingTreeCommon<?> mod;

    @SubscribeEvent
    public void onPlayerLoggedInEvent(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer server = serverPlayer.getServer();
            if (Objects.nonNull(server) && server.isDedicatedServer()) {
                ConfigurationPacket packet = ConfigurationPacket.get(this.mod.getConfiguration());
                ForgePacketHandler.INSTANCE.send((Object)packet, PacketDistributor.PLAYER.with((Object)serverPlayer));
            } else {
                log.info("Player connected to a local world, not setting up proxy config");
            }
        }
    }

    public PlayerJoinListener(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

