/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common.wrapper;

import fr.rakambda.fallingtree.common.wrapper.IEnchantment;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.forge.common.wrapper.ItemWrapper;
import fr.rakambda.fallingtree.forge.compat.TetraCompat;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackWrapper
implements IItemStack {
    @NotNull
    private final ItemStack raw;

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public boolean isDamageable() {
        return this.raw.isDamageableItem();
    }

    @Override
    public int getDamage() {
        return this.raw.getDamageValue();
    }

    @Override
    public int getMaxDamage() {
        return this.raw.getMaxDamage();
    }

    @Override
    public void damage(int amount, @NotNull IPlayer player) {
        this.raw.hurtAndBreak(amount, (LivingEntity)((Player)player.getRaw()), EquipmentSlot.MAINHAND);
        TetraCompat.tickHoningProgression(this, player);
    }

    @Override
    @NotNull
    public IItem getItem() {
        return new ItemWrapper(this.raw.getItem());
    }

    @Override
    public int getEnchantLevel(@Nullable IEnchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        return this.raw.getEnchantmentLevel((Enchantment)enchantment.getRaw());
    }

    @Override
    public boolean hasOneOfEnchantAtLeast(@NotNull Collection<IEnchantment> enchantments, int minLevel) {
        for (IEnchantment enchantment : enchantments) {
            Enchantment key = (Enchantment)enchantment.getRaw();
            if (this.raw.getEnchantmentLevel(key) < minLevel) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Optional<IEnchantment> getAnyEnchant(@NotNull Collection<IEnchantment> enchantments) {
        for (IEnchantment enchantment : enchantments) {
            Enchantment key = (Enchantment)enchantment.getRaw();
            if (this.raw.getEnchantmentLevel(key) <= 0) continue;
            return Optional.of(enchantment);
        }
        return Optional.empty();
    }

    @Override
    public boolean canPerformAxeAction() {
        return this.raw.canPerformAction(ToolActions.AXE_DIG);
    }

    public ItemStackWrapper(@NotNull ItemStack raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    public String toString() {
        return "ItemStackWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @NotNull
    public ItemStack getRaw() {
        return this.raw;
    }
}

