/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.breaking;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.rakambda.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.LeafForceBreaker;
import fr.rakambda.fallingtree.common.tree.breaking.ToolDamageHandler;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FallingAnimationTreeBreakingHandler
implements ITreeBreakingHandler {
    private static final Logger log = LogManager.getLogger(FallingAnimationTreeBreakingHandler.class);
    private static final Map<Map.Entry<Boolean, Boolean>, FallingAnimationTreeBreakingHandler> INSTANCE = new ConcurrentHashMap<Map.Entry<Boolean, Boolean>, FallingAnimationTreeBreakingHandler>();
    private final FallingTreeCommon<?> mod;
    private final boolean dropLogsAsItems;
    private final boolean dropLeavesAsItems;
    private final LeafForceBreaker leafForceBreaker;

    @Override
    public boolean breakTree(@NotNull IPlayer player, @NotNull Tree tree) throws BreakTreeTooBigException {
        IItemStack tool = player.getMainHandItem();
        ILevel level = tree.getLevel();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, this.mod.getConfiguration().getTools().getDamageMultiplicand(), this.mod.getConfiguration().getTools().isPreserve(), tree.getBreakableCount(), this.mod.getConfiguration().getTrees().getMaxSize(), this.mod.getConfiguration().getTrees().getMaxSizeAction(), this.mod.getConfiguration().getTools().getDamageRounding());
        if (this.mod.getConfiguration().getTools().isPreserve() && toolHandler.getMaxBreakCount() <= 0) {
            log.debug("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.prevented_break_tool", new Object[0]));
            return false;
        }
        LinkedList scannedLeaves = new LinkedList();
        int wantToBreakCount = Math.min(tree.getBreakableCount(), toolHandler.getMaxBreakCount());
        int brokenCount = tree.getParts().stream().sorted(this.mod.getConfiguration().getTrees().getBreakOrder().getComparator()).limit(wantToBreakCount).mapToInt(part -> {
            IBlockPos logBlockPos = part.blockPos();
            IBlockState logState = level.getBlockState(logBlockPos);
            if (!tree.getHitPos().equals(logBlockPos) && !this.mod.checkCanBreakBlock(level, logBlockPos, logState, player)) {
                return 0;
            }
            player.awardItemUsed(tool.getItem());
            if (this.dropLogsAsItems && (!player.isCreative() || this.mod.getConfiguration().isLootInCreative())) {
                logState.getBlock().playerDestroy(level, player, logBlockPos, logState, level.getBlockEntity(logBlockPos), tool);
            }
            level.fallBlock(logBlockPos, !this.dropLogsAsItems, 0.0, 0.5, 0.0, (level.getRandom().nextDouble() - 0.5) * 0.4, 0.0, (level.getRandom().nextDouble() - 0.5) * 0.4);
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.below());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.north());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.east());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.south());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.west());
            this.fallLeaf(scannedLeaves, player, level, 5, logBlockPos.above());
            boolean isRemoved = level.removeBlock(logBlockPos, false);
            return part.treePartType().isBreakable() && isRemoved ? 1 : 0;
        }).sum();
        int toolDamage = toolHandler.getActualDamage(brokenCount) - 1;
        if (toolDamage > 0) {
            tool.damage(toolDamage, player);
        }
        if (brokenCount >= wantToBreakCount) {
            this.leafForceBreaker.forceBreakDecayLeaves(player, tree, level);
        }
        return true;
    }

    private void fallLeaf(LinkedList<IBlockPos> scannedLeaves, @NotNull IPlayer player, @NotNull ILevel level, int distance, @NotNull IBlockPos blockPos) {
        if (!this.mod.getConfiguration().getTrees().isLeavesBreaking()) {
            return;
        }
        if (distance == 0) {
            return;
        }
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.below());
        if (scannedLeaves.contains(blockPos)) {
            return;
        }
        scannedLeaves.add(blockPos);
        IBlockState blockState = level.getBlockState(blockPos);
        if (!this.mod.isLeafBlock(blockState.getBlock())) {
            return;
        }
        if (this.dropLeavesAsItems && (!player.isCreative() || this.mod.getConfiguration().isLootInCreative())) {
            blockState.getBlock().playerDestroy(level, player, blockPos, blockState, level.getBlockEntity(blockPos), this.mod.getEmptyItemStack());
        }
        level.fallBlock(blockPos, !this.dropLeavesAsItems, 0.0, 0.5, 0.0, (level.getRandom().nextDouble() - 0.5) * 0.4, 0.0, (level.getRandom().nextDouble() - 0.5) * 0.4);
        level.removeBlock(blockPos, false);
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.north());
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.east());
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.south());
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.west());
        this.fallLeaf(scannedLeaves, player, level, distance - 1, blockPos.above());
    }

    @NotNull
    public static FallingAnimationTreeBreakingHandler getInstance(@NotNull FallingTreeCommon<?> mod, boolean dropLogsAsItems, boolean dropLeavesAsItems) {
        return INSTANCE.computeIfAbsent(Map.entry(dropLogsAsItems, dropLeavesAsItems), key -> new FallingAnimationTreeBreakingHandler(mod, (Boolean)key.getKey(), (Boolean)key.getValue(), new LeafForceBreaker(mod)));
    }

    public FallingAnimationTreeBreakingHandler(FallingTreeCommon<?> mod, boolean dropLogsAsItems, boolean dropLeavesAsItems, LeafForceBreaker leafForceBreaker) {
        this.mod = mod;
        this.dropLogsAsItems = dropLogsAsItems;
        this.dropLeavesAsItems = dropLeavesAsItems;
        this.leafForceBreaker = leafForceBreaker;
    }
}

