/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.tree.AbortedResult;
import fr.rakambda.fallingtree.common.tree.BreakTreeResult;
import fr.rakambda.fallingtree.common.tree.IBreakAttemptResult;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.rakambda.fallingtree.common.tree.breaking.FallingAnimationTreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.InstantaneousTreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.ShiftDownTreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.builder.TreeTooBigException;
import fr.rakambda.fallingtree.common.utils.CacheSpeed;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IEnchantment;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeHandler {
    private static final Logger log = LogManager.getLogger(TreeHandler.class);
    @NotNull
    private final FallingTreeCommon<?> mod;
    private final Map<UUID, CacheSpeed> speedCache = new ConcurrentHashMap<UUID, CacheSpeed>();

    @NotNull
    public IBreakAttemptResult breakTree(@NotNull ILevel level, @NotNull IPlayer player, @NotNull IBlockPos blockPos) {
        if (!level.isServer()) {
            return AbortedResult.NOT_SERVER;
        }
        if (!this.mod.getConfiguration().getTrees().isTreeBreaking()) {
            return AbortedResult.NOT_ENABLED;
        }
        if (!this.mod.checkForceToolUsage(player, level, blockPos)) {
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.force_tool_usage", this.mod.getConfiguration().getTrees().getMaxScanSize()));
            return AbortedResult.REQUIRED_TOOL_ABSENT;
        }
        if (!this.mod.isPlayerInRightState(player)) {
            return AbortedResult.INVALID_PLAYER_STATE;
        }
        try {
            Optional<Tree> treeOptional = this.mod.getTreeBuilder().getTree(player, level, blockPos);
            if (treeOptional.isEmpty()) {
                return AbortedResult.NO_SUCH_TREE;
            }
            Tree tree = treeOptional.get();
            BreakMode breakMode = this.getBreakMode(player.getMainHandItem());
            boolean result = this.getBreakingHandler(breakMode).breakTree(player, tree);
            return new BreakTreeResult(!result, breakMode);
        }
        catch (TreeTooBigException e) {
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.tree_too_big", this.mod.getConfiguration().getTrees().getMaxScanSize()));
            return AbortedResult.TREE_TOO_BIG_SCAN;
        }
        catch (BreakTreeTooBigException e) {
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.break_tree_too_big", this.mod.getConfiguration().getTrees().getMaxSize()));
            return AbortedResult.TREE_TOO_BIG_BREAK;
        }
    }

    @NotNull
    private BreakMode getBreakMode(@NotNull IItemStack itemStack) {
        return itemStack.getAnyEnchant(this.mod.getChopperEnchantments()).flatMap(IEnchantment::getBreakMode).orElseGet(() -> this.mod.getConfiguration().getTrees().getBreakMode());
    }

    @NotNull
    private ITreeBreakingHandler getBreakingHandler(@NotNull BreakMode breakMode) {
        return switch (breakMode) {
            default -> throw new MatchException(null, null);
            case BreakMode.INSTANTANEOUS -> InstantaneousTreeBreakingHandler.getInstance(this.mod);
            case BreakMode.FALL_ITEM -> FallingAnimationTreeBreakingHandler.getInstance(this.mod, true, true);
            case BreakMode.FALL_BLOCK -> FallingAnimationTreeBreakingHandler.getInstance(this.mod, false, true);
            case BreakMode.FALL_ALL_BLOCK -> FallingAnimationTreeBreakingHandler.getInstance(this.mod, false, false);
            case BreakMode.SHIFT_DOWN -> ShiftDownTreeBreakingHandler.getInstance(this.mod);
        };
    }

    @NotNull
    public Optional<Float> getBreakSpeed(@NotNull IPlayer player, @NotNull IBlockPos blockPos, float originalSpeed) {
        if (!this.mod.getConfiguration().getTrees().isTreeBreaking()) {
            return Optional.empty();
        }
        if (!this.getBreakMode(player.getMainHandItem()).isApplySpeedMultiplier()) {
            return Optional.empty();
        }
        if (!this.mod.isPlayerInRightState(player)) {
            return Optional.empty();
        }
        CacheSpeed cacheSpeed = this.speedCache.compute(player.getUUID(), (uuid, speed) -> {
            if (Objects.isNull(speed) || !speed.isValid(blockPos)) {
                speed = this.getSpeed(player, blockPos, originalSpeed);
            }
            return speed;
        });
        return Optional.ofNullable(cacheSpeed).map(CacheSpeed::getSpeed);
    }

    @Nullable
    private CacheSpeed getSpeed(@NotNull IPlayer player, @NotNull IBlockPos pos, float originalSpeed) {
        double speedMultiplicand = this.mod.getConfiguration().getTools().getSpeedMultiplicand();
        try {
            return speedMultiplicand <= 0.0 ? null : (CacheSpeed)this.mod.getTreeBuilder().getTree(player, player.getLevel(), pos).map(tree -> new CacheSpeed(pos, originalSpeed / ((float)speedMultiplicand * (float)tree.getLogCount()))).orElse(null);
        }
        catch (TreeTooBigException e) {
            return null;
        }
    }

    public TreeHandler(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

