/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelResource;
import org.popcraft.chunky.platform.Border;
import org.popcraft.chunky.platform.ForgeBorder;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.util.Input;

public class ForgeWorld
implements World {
    private static final int TICKING_LOAD_DURATION = Input.tryInteger(System.getProperty("chunky.tickingLoadDuration")).orElse(0);
    private static final TicketType<Unit> CHUNKY = TicketType.create((String)"chunky", (unit, unit2) -> 0);
    private static final TicketType<Unit> CHUNKY_TICKING = TicketType.create((String)"%s_ticking".formatted("chunky"), (unit, unit2) -> 0, (int)(TICKING_LOAD_DURATION * 20));
    private static final boolean UPDATE_CHUNK_NBT = Boolean.getBoolean("chunky.updateChunkNbt");
    private final ServerLevel world;
    private final Border worldBorder;

    public ForgeWorld(ServerLevel world) {
        this.world = world;
        this.worldBorder = new ForgeBorder(world.getWorldBorder());
    }

    @Override
    public String getName() {
        return this.world.dimension().location().toString();
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public CompletableFuture<Boolean> isChunkGenerated(int x, int z) {
        if (Thread.currentThread() != this.world.getServer().getRunningThread()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x, z), (Executor)this.world.getServer()).thenCompose(Function.identity());
        }
        ChunkPos chunkPos = new ChunkPos(x, z);
        ServerChunkCache serverChunkCache = this.world.getChunkSource();
        ChunkMap chunkStorage = serverChunkCache.chunkMap;
        ChunkHolder loadedChunkHolder = chunkStorage.getVisibleChunkIfPresent(chunkPos.toLong());
        if (loadedChunkHolder != null && loadedChunkHolder.getLastAvailableStatus() == ChunkStatus.FULL) {
            return CompletableFuture.completedFuture(true);
        }
        ChunkHolder unloadedChunkHolder = (ChunkHolder)chunkStorage.pendingUnloads.get(chunkPos.toLong());
        if (unloadedChunkHolder != null && unloadedChunkHolder.getLastAvailableStatus() == ChunkStatus.FULL) {
            return CompletableFuture.completedFuture(true);
        }
        if (UPDATE_CHUNK_NBT) {
            return chunkStorage.readChunk(chunkPos).thenApply(optionalNbt -> optionalNbt.filter(chunkNbt -> chunkNbt.contains("Status", 8)).map(chunkNbt -> chunkNbt.getString("Status")).map(status -> "minecraft:full".equals(status) || "full".equals(status)).orElse(false));
        }
        FieldSelector statusSelector = new FieldSelector(StringTag.TYPE, "Status");
        CollectFields statusCollector = new CollectFields(new FieldSelector[]{statusSelector});
        return serverChunkCache.chunkScanner().scanChunk(chunkPos, (StreamTagVisitor)statusCollector).thenApply(ignored -> {
            Tag patt0$temp = statusCollector.getResult();
            if (patt0$temp instanceof CompoundTag) {
                CompoundTag chunkNbt = (CompoundTag)patt0$temp;
                String status = chunkNbt.getString("Status");
                return "minecraft:full".equals(status) || "full".equals(status);
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Void> getChunkAtAsync(int x, int z) {
        if (Thread.currentThread() != this.world.getServer().getRunningThread()) {
            return CompletableFuture.supplyAsync(() -> this.getChunkAtAsync(x, z), (Executor)this.world.getServer()).thenCompose(Function.identity());
        }
        ChunkPos chunkPos = new ChunkPos(x, z);
        ServerChunkCache serverChunkCache = this.world.getChunkSource();
        serverChunkCache.addRegionTicket(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE);
        if (TICKING_LOAD_DURATION > 0) {
            serverChunkCache.addRegionTicket(CHUNKY_TICKING, chunkPos, 1, (Object)Unit.INSTANCE);
        }
        serverChunkCache.runDistanceManagerUpdates();
        ChunkMap chunkManager = serverChunkCache.chunkMap;
        ChunkHolder chunkHolder = chunkManager.getVisibleChunkIfPresent(chunkPos.toLong());
        CompletableFuture<Object> chunkFuture = chunkHolder == null ? CompletableFuture.completedFuture(null) : CompletableFuture.allOf(chunkHolder.getOrScheduleFuture(ChunkStatus.FULL, chunkManager));
        chunkFuture.whenCompleteAsync((ignored, throwable) -> serverChunkCache.removeRegionTicket(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE), (Executor)this.world.getServer());
        return chunkFuture;
    }

    @Override
    public UUID getUUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSeaLevel() {
        return this.world.getSeaLevel();
    }

    @Override
    public Location getSpawn() {
        BlockPos pos = this.world.getSharedSpawnPos();
        float rot = this.world.getSharedSpawnAngle();
        return new Location(this, pos.getX(), pos.getY(), pos.getZ(), rot, 0.0f);
    }

    @Override
    public Border getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public int getElevation(int x, int z) {
        int logicalHeight;
        int height = this.world.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) + 1;
        if (height >= (logicalHeight = this.world.getLogicalHeight())) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, logicalHeight, z);
            int air = 0;
            while (pos.getY() > this.world.getMinBuildHeight()) {
                BlockState blockState = this.world.getBlockState((BlockPos)(pos = pos.move(Direction.DOWN)));
                if (blockState.isSolid() && air > 1) {
                    return pos.getY() + 1;
                }
                air = blockState.isAir() ? air + 1 : 0;
            }
        }
        return height;
    }

    @Override
    public int getMaxElevation() {
        return this.world.getLogicalHeight();
    }

    @Override
    public void playEffect(Player player, String effect) {
        Location location = player.getLocation();
        BlockPos pos = BlockPos.containing((double)location.getX(), (double)location.getY(), (double)location.getZ());
        Input.tryInteger(effect).ifPresent(eventId -> this.world.levelEvent(eventId.intValue(), pos, 0));
    }

    @Override
    public void playSound(Player player, String sound) {
        Location location = player.getLocation();
        this.world.getServer().registryAccess().registry(Registries.SOUND_EVENT).flatMap(soundEventRegistry -> soundEventRegistry.getOptional(ResourceLocation.tryParse((String)sound))).ifPresent(soundEvent -> this.world.playSound(null, location.getX(), location.getY(), location.getZ(), soundEvent, SoundSource.MASTER, 2.0f, 1.0f));
    }

    @Override
    public Optional<Path> getDirectory(String name) {
        if (name == null) {
            return Optional.empty();
        }
        Path directory = DimensionType.getStorageFolder((ResourceKey)this.world.dimension(), (Path)this.world.getServer().getWorldPath(LevelResource.ROOT)).normalize().resolve(name);
        return Files.exists(directory, new LinkOption[0]) ? Optional.of(directory) : Optional.empty();
    }

    public ServerLevel getWorld() {
        return this.world;
    }
}

