/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.listeners.bossbar;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.level.Level;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.event.task.GenerationTaskUpdateEvent;
import org.popcraft.chunky.platform.ForgeWorld;
import org.popcraft.chunky.platform.World;

public class BossBarTaskUpdateListener
implements Consumer<GenerationTaskUpdateEvent> {
    private final Map<ResourceLocation, ServerBossEvent> bossBars;

    public BossBarTaskUpdateListener(Map<ResourceLocation, ServerBossEvent> bossBars) {
        this.bossBars = bossBars;
    }

    @Override
    public void accept(GenerationTaskUpdateEvent event) {
        GenerationTask task = event.generationTask();
        Chunky chunky = task.getChunky();
        World world = task.getSelection().world();
        ResourceLocation worldIdentifier = ResourceLocation.tryParse((String)world.getKey());
        if (worldIdentifier == null || !(world instanceof ForgeWorld)) {
            return;
        }
        ForgeWorld forgeWorld = (ForgeWorld)world;
        ServerBossEvent bossBar = this.bossBars.computeIfAbsent(worldIdentifier, x -> this.createNewBossBar(worldIdentifier));
        boolean silent = chunky.getConfig().isSilent();
        if (silent == bossBar.isVisible()) {
            bossBar.setVisible(!silent);
        }
        MinecraftServer server = forgeWorld.getWorld().getServer();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (player.hasPermissions(2)) {
                bossBar.addPlayer(player);
                continue;
            }
            bossBar.removePlayer(player);
        }
        GenerationTask.Progress progress = task.getProgress();
        bossBar.setName(Component.nullToEmpty((String)String.format("%s | %s%% | %s:%s:%s", worldIdentifier, String.format("%.2f", Float.valueOf(progress.getPercentComplete())), String.format("%01d", progress.getHours()), String.format("%02d", progress.getMinutes()), String.format("%02d", progress.getSeconds()))));
        bossBar.setProgress(task.getProgress().getPercentComplete() / 100.0f);
        if (progress.isComplete()) {
            bossBar.removeAllPlayers();
            this.bossBars.remove(worldIdentifier);
        }
    }

    private ServerBossEvent createNewBossBar(ResourceLocation worldIdentifier) {
        ServerBossEvent bossBar = new ServerBossEvent(Component.nullToEmpty((String)worldIdentifier.toString()), BossBarTaskUpdateListener.bossBarColor(worldIdentifier), BossEvent.BossBarOverlay.PROGRESS);
        bossBar.setDarkenScreen(false);
        bossBar.setPlayBossMusic(false);
        bossBar.setCreateWorldFog(false);
        return bossBar;
    }

    private static BossEvent.BossBarColor bossBarColor(ResourceLocation worldIdentifier) {
        BossEvent.BossBarColor bossBarColor = Level.OVERWORLD.location().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.GREEN : (Level.NETHER.location().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.RED : (Level.END.location().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.PURPLE : BossEvent.BossBarColor.BLUE));
        return bossBarColor;
    }
}

