/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BOPFluids;
import biomesoplenty.init.ModTags;
import biomesoplenty.util.worldgen.BOPFeatureUtils;
import biomesoplenty.worldgen.feature.BOPBaseFeatures;
import biomesoplenty.worldgen.placement.BOPTreePlacements;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.Fluids;

public class BOPNetherFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACKSTONE_BULB = BOPFeatureUtils.createKey("blackstone_bulb");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACKSTONE_SPINES = BOPFeatureUtils.createKey("blackstone_spines");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLOOD_LAKE = BOPFeatureUtils.createKey("blood_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLOOD_SPRING = BOPFeatureUtils.createKey("blood_spring");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRIMSTONE_BUD = BOPFeatureUtils.createKey("brimstone_bud");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRIMSTONE_CLUSTER = BOPFeatureUtils.createKey("brimstone_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEAD_GRASS = BOPFeatureUtils.createKey("dead_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EYEBULB = BOPFeatureUtils.createKey("eyebulb");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLESH_TENDON = BOPFeatureUtils.createKey("flesh_tendon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HAIR = BOPFeatureUtils.createKey("hair");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HANGING_FLESH_TENDON = BOPFeatureUtils.createKey("hanging_flesh_tendon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> INFERNO_LAVA_LAKE = BOPFeatureUtils.createKey("inferno_lava_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> INFERNO_LAVA_SPRING = BOPFeatureUtils.createKey("inferno_lava_spring");
    public static final ResourceKey<ConfiguredFeature<?, ?>> INFERNO_SPLATTER = BOPFeatureUtils.createKey("inferno_splatter");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_FUMAROLE = BOPFeatureUtils.createKey("large_fumarole");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_ROSE_QUARTZ = BOPFeatureUtils.createKey("large_rose_quartz");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_BONE_SPINE = BOPFeatureUtils.createKey("nether_bone_spine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_BRAMBLE = BOPFeatureUtils.createKey("nether_bramble");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_VINES = BOPFeatureUtils.createKey("nether_vines");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OBSIDIAN_SPLATTER = BOPFeatureUtils.createKey("obsidian_splatter");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POROUS_FLESH = BOPFeatureUtils.createKey("porous_flesh");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PUS_BUBBLES = BOPFeatureUtils.createKey("pus_bubbles");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_CRYSTAL = BOPFeatureUtils.createKey("small_crystal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_FUMAROLE = BOPFeatureUtils.createKey("small_fumarole");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPROUTS_UNDERGROWTH = BOPFeatureUtils.createKey("sprouts_undergrowth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_UNDERGROWTH = BOPFeatureUtils.createKey("trees_undergrowth");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UNDERGROWTH_FLOWERS = BOPFeatureUtils.createKey("undergrowth_flowers");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeatureGetter = context.lookup(Registries.PLACED_FEATURE);
        Holder.Reference BIG_HELLBARK_TREE_CHECKED = placedFeatureGetter.getOrThrow(BOPTreePlacements.BIG_HELLBARK_TREE_CHECKED);
        Holder.Reference HELLBARK_TREE_CHECKED = placedFeatureGetter.getOrThrow(BOPTreePlacements.HELLBARK_TREE_CHECKED);
        BOPNetherFeatures.register(context, BLACKSTONE_BULB, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.BLACKSTONE_BULB))));
        BOPNetherFeatures.register(context, BLACKSTONE_SPINES, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.BLACKSTONE_SPINES))));
        BOPNetherFeatures.register(context, BLOOD_LAKE, Feature.LAKE, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.BLOOD), (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.FLESH)));
        BOPNetherFeatures.register(context, BLOOD_SPRING, Feature.SPRING, new SpringConfiguration(BOPFluids.BLOOD.defaultFluidState(), false, 4, 1, (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{Blocks.NETHERRACK, BOPBlocks.FLESH, BOPBlocks.POROUS_FLESH})));
        BOPNetherFeatures.register(context, BRIMSTONE_BUD, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.BRIMSTONE_BUD))));
        BOPNetherFeatures.register(context, BRIMSTONE_CLUSTER, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.BRIMSTONE_CLUSTER))));
        BOPNetherFeatures.register(context, DEAD_GRASS, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.DEAD_GRASS))));
        BOPNetherFeatures.register(context, EYEBULB, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.EYEBULB))));
        BOPNetherFeatures.register(context, FLESH_TENDON, BOPBaseFeatures.FLESH_TENDON, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, HAIR, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.HAIR))));
        BOPNetherFeatures.register(context, HANGING_FLESH_TENDON, BOPBaseFeatures.HANGING_FLESH_TENDON, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, INFERNO_LAVA_LAKE, Feature.LAKE, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.LAVA), (BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.BRIMSTONE)));
        BOPNetherFeatures.register(context, INFERNO_LAVA_SPRING, Feature.SPRING, new SpringConfiguration(Fluids.LAVA.defaultFluidState(), false, 4, 1, (HolderSet)HolderSet.direct(Block::builtInRegistryHolder, (Object[])new Block[]{Blocks.NETHERRACK})));
        BOPNetherFeatures.register(context, INFERNO_SPLATTER, BOPBaseFeatures.INFERNO_SPLATTER, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, LARGE_FUMAROLE, BOPBaseFeatures.LARGE_FUMAROLE, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, LARGE_ROSE_QUARTZ, BOPBaseFeatures.LARGE_ROSE_QUARTZ, new LargeDripstoneConfiguration(30, (IntProvider)UniformInt.of((int)3, (int)7), (FloatProvider)UniformFloat.of((float)0.3f, (float)1.8f), 0.33f, (FloatProvider)UniformFloat.of((float)0.3f, (float)0.9f), (FloatProvider)UniformFloat.of((float)0.4f, (float)1.0f), (FloatProvider)UniformFloat.of((float)0.0f, (float)0.3f), 4, 0.6f));
        BOPNetherFeatures.register(context, NETHER_BONE_SPINE, BOPBaseFeatures.BONE_SPINE, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, NETHER_BRAMBLE, BOPBaseFeatures.BRAMBLE, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, NETHER_VINES, BOPBaseFeatures.NETHER_VINES, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, OBSIDIAN_SPLATTER, BOPBaseFeatures.OBSIDIAN_SPLATTER, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, POROUS_FLESH, Feature.ORE, new OreConfiguration((RuleTest)new TagMatchTest(ModTags.Blocks.FLESH), BOPBlocks.POROUS_FLESH.defaultBlockState(), 16));
        BOPNetherFeatures.register(context, PUS_BUBBLES, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.PUS_BUBBLE))));
        BOPNetherFeatures.register(context, SMALL_CRYSTAL, BOPBaseFeatures.SMALL_CRYSTAL, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, SMALL_FUMAROLE, BOPBaseFeatures.SMALL_FUMAROLE, NoneFeatureConfiguration.INSTANCE);
        BOPNetherFeatures.register(context, SPROUTS_UNDERGROWTH, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.SPROUT))));
        BOPNetherFeatures.register(context, TREES_UNDERGROWTH, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration((List)ImmutableList.of((Object)new WeightedPlacedFeature((Holder)BIG_HELLBARK_TREE_CHECKED, 0.4f)), (Holder)HELLBARK_TREE_CHECKED));
        BOPNetherFeatures.register(context, UNDERGROWTH_FLOWERS, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)BOPBlocks.BURNING_BLOSSOM))));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey, F feature, FC configuration) {
        context.register(configuredFeatureKey, (Object)new ConfiguredFeature(feature, configuration));
    }
}

